/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.gson.reflect.TypeToken;
import edu.ksu.canvas.impl.BaseImpl;
import edu.ksu.canvas.impl.GsonResponseParser;
import edu.ksu.canvas.interfaces.QuizReader;
import edu.ksu.canvas.interfaces.QuizWriter;
import edu.ksu.canvas.model.assignment.Quiz;
import edu.ksu.canvas.net.Response;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuizImpl
extends BaseImpl<Quiz, QuizReader, QuizWriter>
implements QuizReader,
QuizWriter {
    private static final Logger LOG = LoggerFactory.getLogger(QuizReader.class);

    public QuizImpl(String canvasBaseUrl, Integer apiVersion, OauthToken oauthToken, RestClient restClient, int connectTimeout, int readTimeout, Integer paginationPageSize, Boolean serializeNulls) {
        super(canvasBaseUrl, apiVersion, oauthToken, restClient, connectTimeout, readTimeout, paginationPageSize, serializeNulls);
    }

    @Override
    public Optional<Quiz> getSingleQuiz(String courseId, String quizId) throws IOException {
        LOG.debug("Retrieving single quiz " + quizId + " in course " + courseId);
        String url = this.buildCanvasUrl("courses/" + courseId + "/quizzes/" + quizId, Collections.emptyMap());
        Response response = this.canvasMessenger.getSingleResponseFromCanvas(this.oauthToken, url);
        return this.responseParser.parseToObject(Quiz.class, response);
    }

    @Override
    public List<Quiz> getQuizzesInCourse(String courseId) throws IOException {
        LOG.debug("Getting quizzes for course " + courseId);
        String url = this.buildCanvasUrl("courses/" + courseId + "/quizzes", Collections.emptyMap());
        List<Response> responses = this.canvasMessenger.getFromCanvas(this.oauthToken, url);
        return this.parseQuizList(responses);
    }

    @Override
    public Optional<Quiz> updateQuiz(Quiz quiz, String courseId) throws IOException {
        LOG.debug("Updating quiz " + quiz.getId() + " in course " + courseId);
        String url = this.buildCanvasUrl("courses/" + courseId + "/quizzes/" + quiz.getId(), Collections.emptyMap());
        Response response = this.canvasMessenger.sendJsonPutToCanvas(this.oauthToken, url, quiz.toJsonObject(this.serializeNulls));
        return this.responseParser.parseToObject(Quiz.class, response);
    }

    private List<Quiz> parseQuizList(List<Response> responses) {
        return responses.stream().map(this::parseQuizList).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<Quiz> parseQuizList(Response response) {
        Type listType = new TypeToken<List<Quiz>>(){}.getType();
        return (List)GsonResponseParser.getDefaultGsonParser(this.serializeNulls).fromJson(response.getContent(), listType);
    }

    @Override
    protected Type listType() {
        return new TypeToken<List<Quiz>>(){}.getType();
    }

    @Override
    protected Class<Quiz> objectType() {
        return Quiz.class;
    }
}

