/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.gson.reflect.TypeToken;
import edu.ksu.canvas.impl.BaseImpl;
import edu.ksu.canvas.impl.GsonResponseParser;
import edu.ksu.canvas.interfaces.QuizSubmissionReader;
import edu.ksu.canvas.interfaces.QuizSubmissionWriter;
import edu.ksu.canvas.model.assignment.QuizSubmission;
import edu.ksu.canvas.model.assignment.QuizSubmissionResponse;
import edu.ksu.canvas.model.wrapper.QuizSubmissionWrapper;
import edu.ksu.canvas.net.Response;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import edu.ksu.canvas.requestOptions.CompleteQuizSubmissionOptions;
import edu.ksu.canvas.requestOptions.GetQuizSubmissionsOptions;
import edu.ksu.canvas.requestOptions.StartQuizSubmissionOptions;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuizSubmissionImpl
extends BaseImpl<QuizSubmission, QuizSubmissionReader, QuizSubmissionWriter>
implements QuizSubmissionReader,
QuizSubmissionWriter {
    private static final Logger LOG = LoggerFactory.getLogger(QuizSubmissionImpl.class);

    public QuizSubmissionImpl(String canvasBaseUrl, Integer apiVersion, OauthToken oauthToken, RestClient restClient, int connectTimeout, int readTimeout, Integer paginationPageSize, Boolean serializeNulls) {
        super(canvasBaseUrl, apiVersion, oauthToken, restClient, connectTimeout, readTimeout, paginationPageSize, serializeNulls);
    }

    @Override
    public List<QuizSubmission> getQuizSubmissions(String courseId, String quizId) throws IOException {
        return this.getQuizSubmissions(new GetQuizSubmissionsOptions(courseId, quizId, new GetQuizSubmissionsOptions.Include[0])).getQuizSubmissions();
    }

    @Override
    public QuizSubmissionResponse getQuizSubmissions(GetQuizSubmissionsOptions options) throws IOException {
        String url = this.buildCanvasUrl("courses/" + options.getCourseId() + "/quizzes/" + options.getQuizId() + "/submissions", options.getOptionsMap());
        List<Response> responses = this.canvasMessenger.getFromCanvas(this.oauthToken, url);
        QuizSubmissionWrapper wrapper = this.parseQuizSubmissionResponses(responses);
        return new QuizSubmissionResponse(wrapper.getQuizSubmissions(), wrapper.getUsers(), wrapper.getQuizzes());
    }

    @Override
    public Optional<QuizSubmission> startQuizSubmission(StartQuizSubmissionOptions options) throws IOException {
        String url = this.buildCanvasUrl("courses/" + options.getCourseId() + "/quizzes/" + options.getQuizId() + "/submissions", options.getOptionsMap());
        Response response = this.canvasMessenger.sendToCanvas(this.oauthToken, url, Collections.emptyMap());
        return Optional.of(this.parseQuizSubmissionResponse(response).getQuizSubmissions().get(0));
    }

    @Override
    public Optional<QuizSubmission> completeQuizSubmission(CompleteQuizSubmissionOptions options) throws IOException {
        LOG.debug("completing quiz submission for user/course/quiz: " + this.masqueradeAs + "/" + options.getCourseId() + "/" + options.getQuizId());
        String url = this.buildCanvasUrl("courses/" + options.getCourseId() + "/quizzes/" + options.getQuizId() + "/submissions/" + options.getSubmissionId() + "/complete", options.getOptionsMap());
        Response response = this.canvasMessenger.sendToCanvas(this.oauthToken, url, Collections.emptyMap());
        return Optional.of(this.parseQuizSubmissionResponse(response).getQuizSubmissions().get(0));
    }

    private QuizSubmissionWrapper parseQuizSubmissionResponses(List<Response> responses) {
        return responses.stream().map(this::parseQuizSubmissionResponse).collect(QuizSubmissionWrapper::new, QuizSubmissionImpl::accumulateQuizSubmissions, QuizSubmissionImpl::accumulateQuizSubmissions);
    }

    private QuizSubmissionWrapper parseQuizSubmissionResponse(Response response) {
        return (QuizSubmissionWrapper)GsonResponseParser.getDefaultGsonParser(this.serializeNulls).fromJson(response.getContent(), QuizSubmissionWrapper.class);
    }

    private static void accumulateQuizSubmissions(QuizSubmissionWrapper result, QuizSubmissionWrapper element) {
        result.getQuizSubmissions().addAll(element.getQuizSubmissions());
        result.getUsers().addAll(element.getUsers());
        result.getQuizzes().addAll(element.getQuizzes());
    }

    @Override
    protected Type listType() {
        return new TypeToken<List<QuizSubmission>>(){}.getType();
    }

    @Override
    protected Class<QuizSubmission> objectType() {
        return QuizSubmission.class;
    }
}

