/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import edu.ksu.canvas.enums.SectionIncludes;
import edu.ksu.canvas.impl.BaseImpl;
import edu.ksu.canvas.interfaces.SectionReader;
import edu.ksu.canvas.interfaces.SectionWriter;
import edu.ksu.canvas.model.Section;
import edu.ksu.canvas.net.Response;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SectionsImpl
extends BaseImpl<Section, SectionReader, SectionWriter>
implements SectionReader,
SectionWriter {
    private static final Logger LOG = LoggerFactory.getLogger(SectionReader.class);

    public SectionsImpl(String canvasBaseUrl, Integer apiVersion, OauthToken oauthToken, RestClient restClient, int connectTimeout, int readTimeout, Integer paginationPageSize, Boolean serializeNulls) {
        super(canvasBaseUrl, apiVersion, oauthToken, restClient, connectTimeout, readTimeout, paginationPageSize, serializeNulls);
    }

    @Override
    public List<Section> listCourseSections(String courseId, List<SectionIncludes> includes) throws IOException {
        LOG.debug("Looking up sections for course " + courseId);
        ImmutableMap parameters = ImmutableMap.builder().put((Object)"include[]", includes.stream().map(Enum::toString).collect(Collectors.toList())).build();
        String url = this.buildCanvasUrl("/courses/" + courseId + "/sections", (Map<String, List<String>>)parameters);
        return this.getListFromCanvas(url);
    }

    @Override
    public Optional<Section> getSingleSection(String sectionId) throws IOException {
        LOG.debug("getting section " + sectionId);
        String url = this.buildCanvasUrl("sections/" + sectionId, new HashMap<String, List<String>>());
        Response response = this.canvasMessenger.getSingleResponseFromCanvas(this.oauthToken, url);
        return this.responseParser.parseToObject(Section.class, response);
    }

    @Override
    protected Type listType() {
        return new TypeToken<List<Section>>(){}.getType();
    }

    @Override
    protected Class<Section> objectType() {
        return Section.class;
    }

    @Override
    public Optional<Section> createSection(String courseId, Section section, Boolean enableSisReactivation) throws IOException {
        LOG.debug("creating section for course " + courseId);
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        if (enableSisReactivation != null) {
            params.put("enable_sis_reactivation", Arrays.asList(Boolean.toString(enableSisReactivation)));
        }
        String url = this.buildCanvasUrl(String.format("/courses/%s/sections", courseId), params);
        Response response = this.canvasMessenger.sendJsonPostToCanvas(this.oauthToken, url, section.toJsonObject(this.serializeNulls));
        return this.responseParser.parseToObject(Section.class, response);
    }

    @Override
    public Optional<Section> updateSection(Section section) throws IOException {
        LOG.debug("updating section " + section.getId());
        String url = this.buildCanvasUrl("sections/" + section.getId(), Collections.emptyMap());
        Response response = this.canvasMessenger.sendJsonPutToCanvas(this.oauthToken, url, section.toJsonObject(this.serializeNulls));
        return this.responseParser.parseToObject(Section.class, response);
    }

    @Override
    public Optional<Section> deleteSection(String sectionId) throws IOException {
        LOG.debug("deleting section " + sectionId);
        String url = this.buildCanvasUrl("/sections/" + sectionId, Collections.emptyMap());
        Response response = this.canvasMessenger.deleteFromCanvas(this.oauthToken, url, Collections.emptyMap());
        return this.responseParser.parseToObject(Section.class, response);
    }

    @Override
    public Optional<Section> crosslist(String sectionId, String courseId) throws IOException {
        LOG.debug("crosslisting section " + sectionId + " to course " + courseId);
        String url = this.buildCanvasUrl("/sections/" + sectionId + "/crosslist/" + courseId, Collections.emptyMap());
        Response response = this.canvasMessenger.sendJsonPostToCanvas(this.oauthToken, url, new JsonObject());
        return this.responseParser.parseToObject(Section.class, response);
    }
}

