/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import edu.ksu.canvas.impl.BaseImpl;
import edu.ksu.canvas.impl.GsonResponseParser;
import edu.ksu.canvas.interfaces.SubmissionReader;
import edu.ksu.canvas.interfaces.SubmissionWriter;
import edu.ksu.canvas.model.Progress;
import edu.ksu.canvas.model.assignment.Submission;
import edu.ksu.canvas.net.Response;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import edu.ksu.canvas.requestOptions.GetSubmissionsOptions;
import edu.ksu.canvas.requestOptions.MultipleSubmissionsOptions;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmissionImpl
extends BaseImpl<Submission, SubmissionReader, SubmissionWriter>
implements SubmissionReader,
SubmissionWriter {
    private static final Logger LOG = LoggerFactory.getLogger(SubmissionImpl.class);

    public SubmissionImpl(String canvasBaseUrl, Integer apiVersion, OauthToken oauthToken, RestClient restClient, int connectTimeout, int readTimeout, Integer paginationPageSize, Boolean serializeNulls) {
        super(canvasBaseUrl, apiVersion, oauthToken, restClient, connectTimeout, readTimeout, paginationPageSize, serializeNulls);
    }

    @Override
    public List<Submission> getCourseSubmissions(GetSubmissionsOptions options) throws IOException {
        if (StringUtils.isBlank((CharSequence)options.getCanvasId()) || options.getAssignmentId() == null) {
            throw new IllegalArgumentException("Course and assignment IDs are required for this API call");
        }
        LOG.debug(String.format("Listing assignment submissions for course %s, assignment %d", options.getCanvasId(), options.getAssignmentId()));
        String url = this.buildCanvasUrl(String.format("courses/%s/assignments/%d/submissions", options.getCanvasId(), options.getAssignmentId()), options.getOptionsMap());
        return this.getListFromCanvas(url);
    }

    @Override
    public List<Submission> listCourseSubmissionsForMultipleAssignments(GetSubmissionsOptions options) throws IOException {
        if (StringUtils.isBlank((CharSequence)options.getCanvasId())) {
            throw new IllegalArgumentException("Course ID is required for this API call");
        }
        LOG.debug(String.format("Listing submissions for multiple assignments in course %s", options.getCanvasId()));
        String url = this.buildCanvasUrl(String.format("courses/%s/students/submissions", options.getCanvasId()), options.getOptionsMap());
        return this.getListFromCanvas(url);
    }

    @Override
    public List<Submission> getSectionSubmissions(GetSubmissionsOptions options) throws IOException {
        if (StringUtils.isBlank((CharSequence)options.getCanvasId()) || options.getAssignmentId() == null) {
            throw new IllegalArgumentException("Section and assignment IDs are required for this API call");
        }
        LOG.debug(String.format("Listing assignment submissions for section %s, assignment %d", options.getCanvasId(), options.getAssignmentId()));
        String url = this.buildCanvasUrl(String.format("sections/%s/assignments/%d/submissions", options.getCanvasId(), options.getAssignmentId()), options.getOptionsMap());
        return this.getListFromCanvas(url);
    }

    @Override
    public Optional<Submission> getSingleCourseSubmission(GetSubmissionsOptions options) throws IOException {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{options.getCanvasId(), options.getUserId()}) || options.getAssignmentId() == null) {
            throw new IllegalArgumentException("Course, assignment and user ID are all required for this API call");
        }
        LOG.debug(String.format("Getting submission for course %s, assignment %d, user %s", options.getCanvasId(), options.getAssignmentId(), options.getUserId()));
        String url = this.buildCanvasUrl(String.format("courses/%s/assignments/%d/submissions/%s", options.getCanvasId(), options.getAssignmentId(), options.getUserId()), options.getOptionsMap());
        return this.getFromCanvas(url);
    }

    @Override
    public Optional<Submission> getSingleSectionSubmission(GetSubmissionsOptions options) throws IOException {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{options.getCanvasId(), options.getUserId()}) || options.getAssignmentId() == null) {
            throw new IllegalArgumentException("Section, assignment and user ID are all required for this API call");
        }
        LOG.debug(String.format("Getting submission for section %s, assignment %d, user %s", options.getCanvasId(), options.getAssignmentId(), options.getUserId()));
        String url = this.buildCanvasUrl(String.format("sections/%s/assignments/%d/submissions/%s", options.getCanvasId(), options.getAssignmentId(), options.getUserId()), options.getOptionsMap());
        return this.getFromCanvas(url);
    }

    @Override
    public Optional<Progress> gradeMultipleSubmissionsBySection(MultipleSubmissionsOptions options) throws IOException {
        LOG.debug("assignment submission for section/" + options.getObjectId());
        String url = this.buildCanvasUrl("sections/" + options.getObjectId() + "/assignments/" + options.getAssignmentId() + "/submissions/update_grades", options.getOptionsMap());
        return this.gradeMultipleSubmissions(options, url);
    }

    @Override
    public Optional<Progress> gradeMultipleSubmissionsByCourse(MultipleSubmissionsOptions options) throws IOException {
        LOG.debug("assignment submission for course/" + options.getObjectId());
        String url = this.buildCanvasUrl("courses/" + options.getObjectId() + "/assignments/" + options.getAssignmentId() + "/submissions/update_grades", options.getOptionsMap());
        return this.gradeMultipleSubmissions(options, url);
    }

    private Optional<Progress> gradeMultipleSubmissions(MultipleSubmissionsOptions options, String url) throws IOException {
        Gson gson = GsonResponseParser.getDefaultGsonParser(this.serializeNulls);
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("grade_data", gson.toJsonTree(options.getStudentSubmissionOptionMap()));
        Response response = this.canvasMessenger.sendJsonPostToCanvas(this.oauthToken, url, jsonObject);
        Progress progress = this.parseProgressResponse(response);
        LOG.debug("ProgressId from assignment section submission response: " + progress.getId());
        return Optional.of(progress);
    }

    private Progress parseProgressResponse(Response response) {
        return (Progress)GsonResponseParser.getDefaultGsonParser(this.serializeNulls).fromJson(response.getContent(), Progress.class);
    }

    @Override
    protected Type listType() {
        return new TypeToken<List<Submission>>(){}.getType();
    }

    @Override
    protected Class<Submission> objectType() {
        return Submission.class;
    }
}

