/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.model;

import edu.ksu.canvas.annotation.CanvasField;
import edu.ksu.canvas.annotation.CanvasObject;
import edu.ksu.canvas.model.BaseCanvasModel;
import edu.ksu.canvas.model.User;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.text.WordUtils;

@CanvasObject(postKey="calendar_event")
public class CalendarEvent
extends BaseCanvasModel
implements Serializable {
    public static final long serialVersionUID = 1L;
    private Integer id;
    private String title;
    private Instant startAt;
    private Instant endAt;
    private String description;
    private String locationName;
    private String locationAddress;
    private String contextCode;
    private String effectiveContextCode;
    private String allContextCodes;
    private WorkflowState workflowState;
    private Boolean hidden;
    private String parentEventId;
    private Integer childEventsCount;
    private List<CalendarEvent> childEvents;
    private List<ChildEvent> childEventsData;
    private String url;
    private String htmlUrl;
    private LocalDate allDayDate;
    private Boolean allDay;
    private Instant createdAt;
    private Instant updatedAt;
    private String appointmentGroupId;
    private String appointmentGroupUrl;
    private Boolean reservation;
    private ParticipantType participantType;
    private Integer participantsPerAppointment;
    private Integer availableSlots;
    private User user;
    private Integer duplicateCount;
    private Integer duplicateInterval;
    private Frequency duplicateFrequency;
    private Boolean duplicateAppend;

    public CalendarEvent() {
    }

    public CalendarEvent(CalendarEvent other) {
        this.id = other.id;
        this.title = other.title;
        this.startAt = other.startAt;
        this.endAt = other.endAt;
        this.description = other.description;
        this.locationName = other.locationName;
        this.locationAddress = other.locationAddress;
        this.contextCode = other.contextCode;
        if (other.childEventsData != null) {
            this.childEventsData = new ArrayList<ChildEvent>();
            for (ChildEvent childEvent : other.childEventsData) {
                this.childEventsData.add(new ChildEvent(childEvent));
            }
        }
        this.allDay = other.allDay;
        this.duplicateCount = other.duplicateCount;
        this.duplicateInterval = other.duplicateInterval;
        this.duplicateFrequency = other.duplicateFrequency;
        this.duplicateAppend = other.duplicateAppend;
        this.effectiveContextCode = other.effectiveContextCode;
        this.allContextCodes = other.allContextCodes;
        this.workflowState = other.workflowState;
        this.hidden = other.hidden;
        this.parentEventId = other.parentEventId;
        this.childEventsCount = other.childEventsCount;
        if (other.childEvents != null) {
            this.childEvents = new ArrayList<CalendarEvent>();
            for (CalendarEvent calendarEvent : other.childEvents) {
                this.childEvents.add(new CalendarEvent(calendarEvent));
            }
        }
        this.url = other.url;
        this.htmlUrl = other.htmlUrl;
        this.allDayDate = other.allDayDate;
        this.createdAt = other.createdAt;
        this.updatedAt = other.updatedAt;
        this.appointmentGroupId = other.appointmentGroupId;
        this.appointmentGroupUrl = other.appointmentGroupUrl;
        this.reservation = other.reservation;
        this.participantsPerAppointment = other.participantsPerAppointment;
        this.participantType = other.participantType;
        this.availableSlots = other.availableSlots;
        if (other.user != null) {
            this.user = new User(other.user);
        }
    }

    public static long getSerialVersionUID() {
        return 1L;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @CanvasField(postKey="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @CanvasField(postKey="start_at")
    public Instant getStartAt() {
        return this.startAt;
    }

    public void setStartAt(Instant startAt) {
        this.startAt = startAt;
    }

    @CanvasField(postKey="end_at")
    public Instant getEndAt() {
        return this.endAt;
    }

    public void setEndAt(Instant endAt) {
        this.endAt = endAt;
    }

    @CanvasField(postKey="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @CanvasField(postKey="location_name")
    public String getLocationName() {
        return this.locationName;
    }

    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    @CanvasField(postKey="location_address")
    public String getLocationAddress() {
        return this.locationAddress;
    }

    public void setLocationAddress(String locationAddress) {
        this.locationAddress = locationAddress;
    }

    @CanvasField(postKey="context_code")
    public String getContextCode() {
        return this.contextCode;
    }

    public void setContextCode(String contextCode) {
        this.contextCode = contextCode;
    }

    public String getEffectiveContextCode() {
        return this.effectiveContextCode;
    }

    public void setEffectiveContextCode(String effectiveContextCode) {
        this.effectiveContextCode = effectiveContextCode;
    }

    public String getAllContextCodes() {
        return this.allContextCodes;
    }

    public void setAllContextCodes(String allContextCodes) {
        this.allContextCodes = allContextCodes;
    }

    public WorkflowState getWorkflowState() {
        return this.workflowState;
    }

    public void setWorkflowState(WorkflowState workflowState) {
        this.workflowState = workflowState;
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public String getParentEventId() {
        return this.parentEventId;
    }

    public void setParentEventId(String parentEventId) {
        this.parentEventId = parentEventId;
    }

    public Integer getChildEventsCount() {
        return this.childEventsCount;
    }

    public void setChildEventsCount(Integer childEventsCount) {
        this.childEventsCount = childEventsCount;
    }

    public List<CalendarEvent> getChildEvents() {
        return this.childEvents;
    }

    public void setChildEvents(List<CalendarEvent> childEvents) {
        this.childEvents = childEvents;
    }

    public String getUrl() {
        return this.url;
    }

    public String getHtmlUrl() {
        return this.htmlUrl;
    }

    public LocalDate getAllDayDate() {
        return this.allDayDate;
    }

    public void setAllDayDate(LocalDate allDayDate) {
        this.allDayDate = allDayDate;
    }

    @CanvasField(postKey="all_day")
    public Boolean getAllDay() {
        return this.allDay;
    }

    public void setAllDay(Boolean allDay) {
        this.allDay = allDay;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Instant updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String getAppointmentGroupId() {
        return this.appointmentGroupId;
    }

    public void setAppointmentGroupId(String appointmentGroupId) {
        this.appointmentGroupId = appointmentGroupId;
    }

    public String getAppointmentGroupUrl() {
        return this.appointmentGroupUrl;
    }

    public void setAppointmentGroupUrl(String appointmentGroupUrl) {
        this.appointmentGroupUrl = appointmentGroupUrl;
    }

    public Boolean getReservation() {
        return this.reservation;
    }

    public void setReservation(Boolean reservation) {
        this.reservation = reservation;
    }

    public ParticipantType getParticipantType() {
        return this.participantType;
    }

    public void setParticipantType(ParticipantType participantType) {
        this.participantType = participantType;
    }

    public Integer getParticipantsPerAppointment() {
        return this.participantsPerAppointment;
    }

    public void setParticipantsPerAppointment(Integer participantsPerAppointment) {
        this.participantsPerAppointment = participantsPerAppointment;
    }

    public Integer getAvailableSlots() {
        return this.availableSlots;
    }

    public void setAvailableSlots(Integer availableSlots) {
        this.availableSlots = availableSlots;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @CanvasField(postKey="count", overrideObjectKey="calendar_event[duplicate]")
    public Integer getDuplicateCount() {
        return this.duplicateCount;
    }

    public void setDuplicateCount(Integer duplicateCount) {
        this.duplicateCount = duplicateCount;
    }

    @CanvasField(postKey="interval", overrideObjectKey="calendar_event[duplicate]")
    public Integer getDuplicateInterval() {
        return this.duplicateInterval;
    }

    public void setDuplicateInterval(Integer duplicateInterval) {
        this.duplicateInterval = duplicateInterval;
    }

    @CanvasField(postKey="frequency", overrideObjectKey="calendar_event[duplicate]")
    public Frequency getDuplicateFrequency() {
        return this.duplicateFrequency;
    }

    public void setDuplicateFrequency(Frequency duplicateFrequency) {
        this.duplicateFrequency = duplicateFrequency;
    }

    @CanvasField(postKey="append_iterator", overrideObjectKey="calendar_event[duplicate]")
    public Boolean getDuplicateAppend() {
        return this.duplicateAppend;
    }

    public void setDuplicateAppend(Boolean duplicateAppend) {
        this.duplicateAppend = duplicateAppend;
    }

    public List<ChildEvent> getChildEventsData() {
        return this.childEventsData;
    }

    public void setChildEventsData(List<ChildEvent> childEventsData) {
        this.childEventsData = childEventsData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CalendarEvent that = (CalendarEvent)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.title, that.title) && Objects.equals(this.startAt, that.startAt) && Objects.equals(this.endAt, that.endAt) && Objects.equals(this.description, that.description) && Objects.equals(this.locationName, that.locationName) && Objects.equals(this.locationAddress, that.locationAddress) && Objects.equals(this.contextCode, that.contextCode) && Objects.equals(this.effectiveContextCode, that.effectiveContextCode) && Objects.equals(this.allContextCodes, that.allContextCodes) && this.workflowState == that.workflowState && Objects.equals(this.hidden, that.hidden) && Objects.equals(this.parentEventId, that.parentEventId) && Objects.equals(this.childEventsCount, that.childEventsCount) && Objects.equals(this.childEvents, that.childEvents) && Objects.equals(this.childEventsData, that.childEventsData) && Objects.equals(this.url, that.url) && Objects.equals(this.htmlUrl, that.htmlUrl) && Objects.equals(this.allDayDate, that.allDayDate) && Objects.equals(this.allDay, that.allDay) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.updatedAt, that.updatedAt) && Objects.equals(this.appointmentGroupId, that.appointmentGroupId) && Objects.equals(this.appointmentGroupUrl, that.appointmentGroupUrl) && Objects.equals(this.reservation, that.reservation) && this.participantType == that.participantType && Objects.equals(this.participantsPerAppointment, that.participantsPerAppointment) && Objects.equals(this.availableSlots, that.availableSlots) && Objects.equals(this.user, that.user) && Objects.equals(this.duplicateCount, that.duplicateCount) && Objects.equals(this.duplicateInterval, that.duplicateInterval) && this.duplicateFrequency == that.duplicateFrequency && Objects.equals(this.duplicateAppend, that.duplicateAppend);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.title, this.startAt, this.endAt, this.description, this.locationName, this.locationAddress, this.contextCode, this.effectiveContextCode, this.allContextCodes, this.workflowState, this.hidden, this.parentEventId, this.childEventsCount, this.childEvents, this.childEventsData, this.url, this.htmlUrl, this.allDayDate, this.allDay, this.createdAt, this.updatedAt, this.appointmentGroupId, this.appointmentGroupUrl, this.reservation, this.participantType, this.participantsPerAppointment, this.availableSlots, this.user, this.duplicateCount, this.duplicateInterval, this.duplicateFrequency, this.duplicateAppend});
    }

    @CanvasObject(postKey="")
    public static class ChildEvent
    extends BaseCanvasModel
    implements Serializable {
        public static final long serialVersionUID = 1L;
        private Instant startAt;
        private Instant endAt;
        private String contextCode;

        public ChildEvent() {
        }

        public ChildEvent(ChildEvent other) {
            this.startAt = other.startAt;
            this.endAt = other.endAt;
            this.contextCode = other.contextCode;
        }

        @CanvasField(postKey="start_at")
        public Instant getStartAt() {
            return this.startAt;
        }

        public void setStartAt(Instant startAt) {
            this.startAt = startAt;
        }

        @CanvasField(postKey="end_at")
        public Instant getEndAt() {
            return this.endAt;
        }

        public void setEndAt(Instant endAt) {
            this.endAt = endAt;
        }

        @CanvasField(postKey="context_code")
        public String getContextCode() {
            return this.contextCode;
        }

        public void setContextCode(String contextCode) {
            this.contextCode = contextCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChildEvent that = (ChildEvent)o;
            return Objects.equals(this.startAt, that.startAt) && Objects.equals(this.endAt, that.endAt) && Objects.equals(this.contextCode, that.contextCode);
        }

        public int hashCode() {
            return Objects.hash(this.startAt, this.endAt, this.contextCode);
        }
    }

    public static enum Frequency {
        DAILY,
        WEEKLY,
        MONTHLY;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum ParticipantType {
        GROUP,
        USER;


        public String toString() {
            return WordUtils.capitalizeFully((String)this.name());
        }
    }

    public static enum WorkflowState {
        ACTIVE,
        LOCKED,
        DELETED;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

