/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.model.assignment;

import com.google.common.collect.ImmutableList;
import edu.ksu.canvas.model.User;
import edu.ksu.canvas.model.assignment.Quiz;
import edu.ksu.canvas.model.assignment.QuizSubmission;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class QuizSubmissionResponse {
    private final List<QuizSubmission> quizSubmissions;
    private final Map<Long, User> users;
    private final Map<Integer, Quiz> quizzes;

    public QuizSubmissionResponse(List<QuizSubmission> quizSubmissions, List<User> users, List<Quiz> quizzes) {
        this.quizSubmissions = ImmutableList.copyOf(quizSubmissions);
        this.users = users.stream().distinct().collect(Collectors.toMap(User::getId, Function.identity()));
        this.quizzes = quizzes.stream().distinct().collect(Collectors.toMap(Quiz::getId, Function.identity()));
    }

    public List<QuizSubmission> getQuizSubmissions() {
        return this.quizSubmissions;
    }

    public Map<Long, User> getUsers() {
        return this.users;
    }

    public Optional<User> getUser(long userId) {
        return Optional.ofNullable(this.users.get(userId));
    }

    public Map<Integer, Quiz> getQuizzes() {
        return this.quizzes;
    }

    public Optional<Quiz> getQuiz(int quizId) {
        return Optional.ofNullable(this.quizzes.get(quizId));
    }
}

