/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.oauth;

import edu.ksu.canvas.exception.InvalidOauthTokenException;
import edu.ksu.canvas.oauth.OauthToken;
import edu.ksu.canvas.oauth.OauthTokenRefresher;
import edu.ksu.canvas.oauth.TokenRefreshResponse;
import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshableOauthToken
implements OauthToken {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RefreshableOauthToken.class);
    private OauthTokenRefresher tokenRefresher;
    private String refreshToken;
    private String apiToken;
    private TokenExpiration tokenExpiration;

    public RefreshableOauthToken(OauthTokenRefresher tokenRefresher, String refreshToken, String accessToken) {
        this.refreshToken = refreshToken;
        this.apiToken = accessToken;
        this.tokenRefresher = tokenRefresher;
        this.tokenExpiration = new TokenExpiration(null);
    }

    public RefreshableOauthToken(OauthTokenRefresher tokenRefresher, String refreshToken) {
        this.refreshToken = refreshToken;
        this.tokenRefresher = tokenRefresher;
        this.refresh();
    }

    @Override
    public void refresh() {
        try {
            TokenRefreshResponse refreshResponse = this.tokenRefresher.getNewToken(this.refreshToken);
            if (refreshResponse == null) {
                throw new InvalidOauthTokenException();
            }
            this.apiToken = refreshResponse.getAccessToken();
            this.tokenExpiration = new TokenExpiration(refreshResponse.getExpiresIn());
        }
        catch (IOException e) {
            LOG.error("Exception while attempting to refresh access token");
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getAccessToken() {
        if (this.tokenExpiration.isExpired()) {
            this.refresh();
        }
        return this.apiToken;
    }

    protected Date now() {
        return new Date();
    }

    private class TokenExpiration {
        Date lastRefreshed;
        Long timeToLiveMS;

        TokenExpiration(Long timeToLiveSeconds) {
            this.lastRefreshed = RefreshableOauthToken.this.now();
            if (timeToLiveSeconds != null) {
                this.timeToLiveMS = timeToLiveSeconds * 1000L;
            }
        }

        boolean isExpired() {
            if (this.timeToLiveMS == null) {
                return false;
            }
            return RefreshableOauthToken.this.now().getTime() - this.lastRefreshed.getTime() >= this.timeToLiveMS;
        }
    }
}

