/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.requestOptions;

import edu.ksu.canvas.requestOptions.BaseOptions;

public class CreateContentMigrationOptions
extends BaseOptions {
    protected final String sourceCourseId;
    protected final MigrationType migrationType;

    public CreateContentMigrationOptions(String sourceCourseId, MigrationType migrationType) {
        this.sourceCourseId = sourceCourseId;
        this.migrationType = migrationType;
        this.addSingleItem("settings[source_course_id]", sourceCourseId);
        this.addSingleItem("migration_type", migrationType.toString().toLowerCase());
    }

    public String getSourceCourseId() {
        return this.sourceCourseId;
    }

    public MigrationType getMigrationType() {
        return this.migrationType;
    }

    public CreateContentMigrationOptions preAttachment(String name) {
        this.addSingleItem("pre_attachment[name]", name);
        return this;
    }

    public CreateContentMigrationOptions addFileUploadProperty(String name, String value) {
        this.addSingleItem("pre_attachment[" + name + "]", value);
        return this;
    }

    public CreateContentMigrationOptions fileUrl(String fileUrl) {
        this.addSingleItem("settings[file_url]", fileUrl);
        return this;
    }

    public CreateContentMigrationOptions contentExport(String contentExportId) {
        this.addSingleItem("settings[content_export_id]", contentExportId);
        return this;
    }

    public CreateContentMigrationOptions folder(String folderId) {
        this.addSingleItem("settings[folder_id]", folderId);
        return this;
    }

    public static enum MigrationType {
        course_copy_importer,
        zip_file_importer,
        common_cartridge_importer,
        canvas_cartridge_importer,
        qti_converter,
        moodle_converter;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

