/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.requestOptions;

import edu.ksu.canvas.requestOptions.BaseOptions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class GetAssignmentGroupOptions
extends BaseOptions {
    private String courseId;
    private Integer assignmentGroupId;

    public GetAssignmentGroupOptions(String courseId, Integer assignmentGroupId) {
        if (StringUtils.isBlank((CharSequence)courseId) || assignmentGroupId == null || assignmentGroupId == 0) {
            throw new IllegalArgumentException("Must supply a course ID and assignment group ID");
        }
        this.courseId = courseId;
        this.assignmentGroupId = assignmentGroupId;
    }

    public String getCourseId() {
        return this.courseId;
    }

    public Integer getAssignmentGroupId() {
        return this.assignmentGroupId;
    }

    public GetAssignmentGroupOptions includes(List<Include> includes) {
        List<Include> assignmentDependents = Arrays.asList(Include.DISCUSSION_TOPIC, Include.ASSIGNMENT_VISIBILITY, Include.SUBMISSION);
        if (includes.stream().anyMatch(assignmentDependents::contains) && !includes.contains((Object)Include.ASSIGNMENTS)) {
            throw new IllegalArgumentException("Including discussion topics, all dates, assignment visibility or submissions is only valid if you also include submissions");
        }
        this.addEnumList("include[]", includes);
        return this;
    }

    public GetAssignmentGroupOptions overrideAssignmentDates(Boolean overrideDates) {
        this.addSingleItem("override_assignment_dates", overrideDates.toString());
        return this;
    }

    public GetAssignmentGroupOptions gradingPeriodId(Integer periodId) {
        this.addSingleItem("grading_period_id", periodId.toString());
        return this;
    }

    public static enum Include {
        ASSIGNMENTS,
        DISCUSSION_TOPIC,
        ASSIGNMENT_VISIBILITY,
        SUBMISSION;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

