/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.requestOptions;

import edu.ksu.canvas.requestOptions.BaseOptions;
import java.util.List;

public class GetUsersInCourseOptions
extends BaseOptions {
    private String courseId;

    public GetUsersInCourseOptions(String courseId) {
        this.courseId = courseId;
    }

    public String getCourseId() {
        return this.courseId;
    }

    public GetUsersInCourseOptions searchTerm(String searchTerm) {
        this.addSingleItem("search_term", searchTerm);
        return this;
    }

    public GetUsersInCourseOptions enrollmentType(List<EnrollmentType> enrollmentTypes) {
        this.addEnumList("enrollment_type[]", enrollmentTypes);
        return this;
    }

    public GetUsersInCourseOptions enrollmentRoleId(Integer roleId) {
        this.addSingleItem("enrollment_role_id", roleId.toString());
        return this;
    }

    public GetUsersInCourseOptions include(List<Include> includes) {
        this.addEnumList("include[]", includes);
        return this;
    }

    public GetUsersInCourseOptions userId(String userId) {
        this.addSingleItem("user_id", userId);
        return this;
    }

    public GetUsersInCourseOptions userIds(List<String> userIds) {
        this.optionsMap.put("user_ids[]", userIds);
        return this;
    }

    public GetUsersInCourseOptions enrollmentState(List<EnrollmentState> enrollmentStates) {
        this.addEnumList("enrollment_state[]", enrollmentStates);
        return this;
    }

    public static enum EnrollmentState {
        ACTIVE,
        INVITED,
        REJECTED,
        COMPLETED,
        INACTIVE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum Include {
        EMAIL,
        ENROLLMENTS,
        LOCKED,
        AVATAR_URL,
        TEST_STUDENT,
        BIO,
        CUSTOM_LINKS;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum EnrollmentType {
        TEACHER,
        STUDENT,
        STUDENT_VIEW,
        TA,
        OBSERVER,
        DESIGNER;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

