/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.gson.reflect.TypeToken;
import edu.ksu.canvas.impl.BaseImpl;
import edu.ksu.canvas.interfaces.CourseReader;
import edu.ksu.canvas.interfaces.CourseWriter;
import edu.ksu.canvas.model.Course;
import edu.ksu.canvas.model.Deposit;
import edu.ksu.canvas.model.Progress;
import edu.ksu.canvas.model.status.Conclude;
import edu.ksu.canvas.model.status.Delete;
import edu.ksu.canvas.net.Response;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import edu.ksu.canvas.requestOptions.DeleteCourseOptions;
import edu.ksu.canvas.requestOptions.GetSingleCourseOptions;
import edu.ksu.canvas.requestOptions.ListActiveCoursesInAccountOptions;
import edu.ksu.canvas.requestOptions.ListCurrentUserCoursesOptions;
import edu.ksu.canvas.requestOptions.ListUserCoursesOptions;
import edu.ksu.canvas.requestOptions.UploadOptions;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CourseImpl
extends BaseImpl<Course, CourseReader, CourseWriter>
implements CourseReader,
CourseWriter {
    private static final Logger LOG = LoggerFactory.getLogger(CourseImpl.class);

    public CourseImpl(String canvasBaseUrl, Integer apiVersion, OauthToken oauthToken, RestClient restClient, int connectTimeout, int readTimeout, Integer paginationPageSize, Boolean serializeNulls) {
        super(canvasBaseUrl, apiVersion, oauthToken, restClient, connectTimeout, readTimeout, paginationPageSize, serializeNulls);
    }

    @Override
    public List<Course> listCurrentUserCourses(ListCurrentUserCoursesOptions options) throws IOException {
        LOG.debug("listing courses for user");
        String url = this.buildCanvasUrl("courses/", options.getOptionsMap());
        return this.getListFromCanvas(url);
    }

    @Override
    public List<Course> listUserCourses(ListUserCoursesOptions options) throws IOException {
        LOG.debug("listing course for user {}", (Object)options.getUserId());
        String url = this.buildCanvasUrl("users/" + options.getUserId() + "/courses", options.getOptionsMap());
        return this.getListFromCanvas(url);
    }

    @Override
    public Optional<Course> getSingleCourse(GetSingleCourseOptions options) throws IOException {
        LOG.debug("getting course {}", (Object)options.getCourseId());
        String path = "";
        String accountId = options.getAccount();
        path = accountId != null ? path + "accounts/" + accountId + "/courses/" : "courses/";
        String url = this.buildCanvasUrl(path + options.getCourseId(), options.getOptionsMap());
        return this.retrieveCourseFromCanvas(this.oauthToken, url);
    }

    @Override
    public Optional<Course> getSingleCourse(String accountId, GetSingleCourseOptions options) throws IOException {
        LOG.debug("getting course {} in account {}", (Object)options.getCourseId(), (Object)accountId);
        String url = this.buildCanvasUrl("accounts/" + accountId + "/courses/" + options.getCourseId(), options.getOptionsMap());
        return this.retrieveCourseFromCanvas(this.oauthToken, url);
    }

    private Optional<Course> retrieveCourseFromCanvas(OauthToken oauthToken, String url) throws IOException {
        Response response = this.canvasMessenger.getSingleResponseFromCanvas(oauthToken, url);
        if (response.getErrorHappened() || response.getResponseCode() != 200) {
            return Optional.empty();
        }
        return this.responseParser.parseToObject(Course.class, response);
    }

    @Override
    public Optional<Course> createCourse(String accountId, Course course) throws IOException {
        LOG.debug("creating course in account {}", (Object)accountId);
        String url = this.buildCanvasUrl("accounts/" + accountId + "/courses", Collections.emptyMap());
        Response response = this.canvasMessenger.sendJsonPostToCanvas(this.oauthToken, url, course.toJsonObject(this.serializeNulls));
        return this.responseParser.parseToObject(Course.class, response);
    }

    @Override
    public Optional<Course> updateCourse(Course course) throws IOException {
        LOG.debug("updating course{}", (Object)course.getId());
        String url = this.buildCanvasUrl("courses/" + course.getId(), Collections.emptyMap());
        Response response = this.canvasMessenger.sendJsonPutToCanvas(this.oauthToken, url, course.toJsonObject(this.serializeNulls));
        return this.responseParser.parseToObject(Course.class, response);
    }

    @Override
    public Optional<Course> updateCourse(String id, Course course) throws IOException {
        LOG.debug("updating course {}", (Object)id);
        String url = this.buildCanvasUrl("courses/" + this.encode(id), Collections.emptyMap());
        Response response = this.canvasMessenger.sendJsonPutToCanvas(this.oauthToken, url, course.toJsonObject(this.serializeNulls));
        return this.responseParser.parseToObject(Course.class, response);
    }

    @Override
    public Boolean deleteCourse(String courseId) throws IOException {
        LOG.debug("Deleting course {}", (Object)courseId);
        HashMap<String, List<String>> postParams = new HashMap<String, List<String>>();
        postParams.put("event", Collections.singletonList("delete"));
        String createdUrl = this.buildCanvasUrl("courses/" + courseId, Collections.emptyMap());
        Response response = this.canvasMessenger.deleteFromCanvas(this.oauthToken, createdUrl, postParams);
        if (response.getErrorHappened() || response.getResponseCode() != 200) {
            LOG.debug("Failed to delete course, error message: " + response.toString());
            return false;
        }
        Optional<Delete> responseParsed = this.responseParser.parseToObject(Delete.class, response);
        return responseParsed.map(r -> r.getDelete()).orElse(false);
    }

    @Override
    public Boolean deleteCourse(DeleteCourseOptions options) throws IOException {
        LOG.debug("Deleting course {}", (Object)options.getCourseId());
        String path = "";
        String accountId = options.getAccountId();
        path = accountId != null ? path + "accounts/" + accountId + "/courses/" : "courses/";
        String url = this.buildCanvasUrl(path + options.getCourseId(), Collections.emptyMap());
        Response response = this.canvasMessenger.deleteFromCanvas(this.oauthToken, url, options.getOptionsMap());
        if (response.getErrorHappened() || response.getResponseCode() != 200) {
            LOG.debug("Failed to delete course, error message: {}", (Object)response);
            return false;
        }
        if (options.getEventType() == DeleteCourseOptions.EventType.DELETE) {
            Optional<Delete> responseParsed = this.responseParser.parseToObject(Delete.class, response);
            return responseParsed.map(Delete::getDelete).orElse(false);
        }
        if (options.getEventType() == DeleteCourseOptions.EventType.CONCLUDE) {
            Optional<Conclude> responseParsed = this.responseParser.parseToObject(Conclude.class, response);
            return responseParsed.map(Conclude::getConclude).orElse(false);
        }
        throw new IllegalArgumentException("Unknown Canvas response: " + response.getContent());
    }

    @Override
    public List<Course> listActiveCoursesInAccount(ListActiveCoursesInAccountOptions options) throws IOException {
        String url = this.buildCanvasUrl("accounts/" + options.getAccountId() + "/courses", options.getOptionsMap());
        return this.getListFromCanvas(url);
    }

    @Override
    public Optional<Deposit> uploadFile(String courseId, UploadOptions uploadOptions) throws IOException {
        String url = this.buildCanvasUrl("courses/" + courseId + "/files", Collections.emptyMap());
        Response response = this.canvasMessenger.sendToCanvas(this.oauthToken, url, uploadOptions.getOptionsMap());
        return this.responseParser.parseToObject(Deposit.class, response);
    }

    @Override
    public Optional<Progress> batchUpdateCourseState(String accountId, Course.CourseEvent event, String ... courseIds) throws IOException {
        if (StringUtils.isBlank((CharSequence)accountId) || event == null || courseIds == null || courseIds.length == 0) {
            throw new IllegalArgumentException("Must supply account, event, and list of courses");
        }
        if (Course.CourseEvent.claim == event) {
            throw new IllegalArgumentException("This method can not be used to claim courses");
        }
        LOG.debug("Updating course workflow state for {} course(s)", (Object)courseIds.length);
        HashMap<String, List<String>> requestParams = new HashMap<String, List<String>>();
        requestParams.put("event", Collections.singletonList(event.toString()));
        requestParams.put("course_ids[]", Arrays.asList(courseIds));
        String url = this.buildCanvasUrl("accounts/" + accountId + "/courses", Collections.emptyMap());
        Response response = this.canvasMessenger.putToCanvas(this.oauthToken, url, requestParams);
        return this.responseParser.parseToObject(Progress.class, response);
    }

    @Override
    protected Type listType() {
        return new TypeToken<List<Course>>(){}.getType();
    }

    @Override
    protected Class<Course> objectType() {
        return Course.class;
    }
}

