/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.gson.reflect.TypeToken;
import edu.ksu.canvas.impl.BaseImpl;
import edu.ksu.canvas.interfaces.EnrollmentReader;
import edu.ksu.canvas.interfaces.EnrollmentWriter;
import edu.ksu.canvas.model.Enrollment;
import edu.ksu.canvas.net.Response;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import edu.ksu.canvas.requestOptions.GetEnrollmentOptions;
import edu.ksu.canvas.requestOptions.UnEnrollOptions;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrollmentImpl
extends BaseImpl<Enrollment, EnrollmentReader, EnrollmentWriter>
implements EnrollmentReader,
EnrollmentWriter {
    private static final Logger LOG = LoggerFactory.getLogger(EnrollmentImpl.class);

    public EnrollmentImpl(String canvasBaseUrl, Integer apiVersion, OauthToken oauthToken, RestClient restClient, int connectTimeout, int readTimeout, Integer paginationPageSize, Boolean serializeNulls) {
        super(canvasBaseUrl, apiVersion, oauthToken, restClient, connectTimeout, readTimeout, paginationPageSize, serializeNulls);
    }

    @Override
    public List<Enrollment> getUserEnrollments(GetEnrollmentOptions options) throws IOException {
        LOG.debug("Retrieving user enrollments for user {}", (Object)options.getObjectId());
        String url = this.buildCanvasUrl("users/" + options.getObjectId() + "/enrollments", options.getOptionsMap());
        return this.getListFromCanvas(url);
    }

    @Override
    public List<Enrollment> getSectionEnrollments(GetEnrollmentOptions options) throws IOException {
        LOG.debug("Retrieving section enrollments for section {}", (Object)options.getObjectId());
        String url = this.buildCanvasUrl("sections/" + options.getObjectId() + "/enrollments", options.getOptionsMap());
        return this.getListFromCanvas(url);
    }

    @Override
    public List<Enrollment> getCourseEnrollments(GetEnrollmentOptions options) throws IOException {
        LOG.debug("Retrieving course enrollments for course {}", (Object)options.getObjectId());
        String url = this.buildCanvasUrl("courses/" + options.getObjectId() + "/enrollments", options.getOptionsMap());
        return this.getListFromCanvas(url);
    }

    @Override
    @Deprecated
    public Optional<Enrollment> enrollUser(Enrollment enrollment) throws IOException {
        if (enrollment.getCourseId() == null || enrollment.getCourseId() == 0L) {
            throw new IllegalArgumentException("Required CourseId in enrollment was not found.");
        }
        return this.enrollUser(enrollment, false);
    }

    @Override
    public Optional<Enrollment> enrollUserInCourse(Enrollment enrollment) throws IOException {
        if (enrollment.getCourseId() == null || enrollment.getCourseId() == 0L) {
            throw new IllegalArgumentException("Required CourseId in enrollment was not found.");
        }
        LOG.debug("Enrolling user {} in course {}", (Object)enrollment.getUserId(), (Object)enrollment.getCourseId());
        return this.enrollUser(enrollment, false);
    }

    @Override
    public Optional<Enrollment> enrollUserInSection(Enrollment enrollment) throws IOException {
        if (StringUtils.isBlank((CharSequence)enrollment.getCourseSectionId())) {
            throw new IllegalArgumentException("Required CourseSectionId in enrollment was not found.");
        }
        LOG.debug("Enrolling user {} in section {}", (Object)enrollment.getUserId(), (Object)enrollment.getCourseSectionId());
        return this.enrollUser(enrollment, true);
    }

    @Override
    public Optional<Enrollment> dropUser(String courseId, String enrollmentId) throws IOException {
        return this.dropUser(courseId, enrollmentId, UnEnrollOptions.DELETE);
    }

    @Override
    public Optional<Enrollment> dropUser(String courseId, String enrollmentId, UnEnrollOptions unEnrollOption) throws IOException {
        LOG.debug("Removing enrollment {} from course {}", (Object)enrollmentId, (Object)courseId);
        HashMap<String, List<String>> postParams = new HashMap<String, List<String>>();
        postParams.put("task", Collections.singletonList(unEnrollOption.toString()));
        String url = this.buildCanvasUrl("courses/" + courseId + "/enrollments/" + enrollmentId, Collections.emptyMap());
        Response response = this.canvasMessenger.deleteFromCanvas(this.oauthToken, url, postParams);
        if (response.getErrorHappened() || response.getResponseCode() != 200) {
            LOG.error("Failed to drop user from course, error message: {}", (Object)response);
            return Optional.empty();
        }
        return this.responseParser.parseToObject(Enrollment.class, response);
    }

    private Optional<Enrollment> enrollUser(Enrollment enrollment, boolean isSectionEnrollment) throws IOException {
        String createdUrl = null;
        createdUrl = isSectionEnrollment ? this.buildCanvasUrl("sections/" + enrollment.getCourseSectionId() + "/enrollments", Collections.emptyMap()) : this.buildCanvasUrl("courses/" + enrollment.getCourseId() + "/enrollments", Collections.emptyMap());
        LOG.debug("create URl for course enrollments: {}", (Object)createdUrl);
        Response response = this.canvasMessenger.sendToCanvas(this.oauthToken, createdUrl, enrollment.toPostMap(this.serializeNulls));
        if (response.getErrorHappened() || response.getResponseCode() != 200) {
            LOG.error("Failed to enroll in course, error message: {}", (Object)response);
            return Optional.empty();
        }
        return this.responseParser.parseToObject(Enrollment.class, response);
    }

    @Override
    protected Type listType() {
        return new TypeToken<List<Enrollment>>(){}.getType();
    }

    @Override
    protected Class<Enrollment> objectType() {
        return Enrollment.class;
    }
}

