/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.gson.reflect.TypeToken;
import edu.ksu.canvas.impl.BaseImpl;
import edu.ksu.canvas.impl.GsonResponseParser;
import edu.ksu.canvas.interfaces.EnrollmentTermReader;
import edu.ksu.canvas.interfaces.EnrollmentTermWriter;
import edu.ksu.canvas.model.EnrollmentTerm;
import edu.ksu.canvas.model.wrapper.EnrollmentTermWrapper;
import edu.ksu.canvas.net.Response;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import edu.ksu.canvas.requestOptions.GetEnrollmentTermOptions;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrollmentTermImpl
extends BaseImpl<EnrollmentTerm, EnrollmentTermReader, EnrollmentTermWriter>
implements EnrollmentTermReader,
EnrollmentTermWriter {
    private static final Logger LOG = LoggerFactory.getLogger(EnrollmentTermImpl.class);

    public EnrollmentTermImpl(String canvasBaseUrl, Integer apiVersion, OauthToken oauthToken, RestClient restClient, int connectTimeout, int readTimeout, Integer paginationPageSize, Boolean serializeNulls) {
        super(canvasBaseUrl, apiVersion, oauthToken, restClient, connectTimeout, readTimeout, paginationPageSize, serializeNulls);
    }

    @Override
    public List<EnrollmentTerm> getEnrollmentTerms(GetEnrollmentTermOptions options) throws IOException {
        LOG.debug("getting enrollment term with account id {}", (Object)options.getAccountId());
        String url = this.buildCanvasUrl("accounts/" + options.getAccountId() + "/terms/", options.getOptionsMap());
        List<Response> response = this.canvasMessenger.getFromCanvas(this.oauthToken, url);
        return this.parseEnrollmentTermList(response);
    }

    @Override
    public Optional<EnrollmentTerm> getEnrollmentTerm(String accountId, String termId) throws IOException {
        LOG.debug("getting enrollment term with account id {}", (Object)accountId);
        String url = this.buildCanvasUrl("accounts/" + accountId + "/terms/" + termId, Collections.emptyMap());
        Response response = this.canvasMessenger.getSingleResponseFromCanvas(this.oauthToken, url);
        return Optional.of(GsonResponseParser.getDefaultGsonParser(this.serializeNulls).fromJson(response.getContent(), EnrollmentTerm.class));
    }

    private List<EnrollmentTerm> parseEnrollmentTermList(List<Response> responses) {
        return responses.stream().map(this::parseEnrollmentTermList).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<EnrollmentTerm> parseEnrollmentTermList(Response response) {
        EnrollmentTermWrapper wrapper = (EnrollmentTermWrapper)GsonResponseParser.getDefaultGsonParser(this.serializeNulls).fromJson(response.getContent(), EnrollmentTermWrapper.class);
        return wrapper.getEnrollmentTerms();
    }

    @Override
    protected Type listType() {
        return new TypeToken<List<EnrollmentTerm>>(){}.getType();
    }

    @Override
    protected Class<EnrollmentTerm> objectType() {
        return EnrollmentTerm.class;
    }
}

