/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import edu.ksu.canvas.impl.BaseImpl;
import edu.ksu.canvas.impl.GsonResponseParser;
import edu.ksu.canvas.interfaces.ExternalToolReader;
import edu.ksu.canvas.interfaces.ExternalToolWriter;
import edu.ksu.canvas.model.ExternalTool;
import edu.ksu.canvas.net.Response;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import edu.ksu.canvas.requestOptions.ListExternalToolsOptions;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalToolImpl
extends BaseImpl<ExternalTool, ExternalToolReader, ExternalToolWriter>
implements ExternalToolReader,
ExternalToolWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalToolImpl.class);

    public ExternalToolImpl(String canvasBaseUrl, Integer apiVersion, OauthToken oauthToken, RestClient restClient, int connectTimeout, int readTimeout, Integer paginationPageSize, Boolean serializeNulls) {
        super(canvasBaseUrl, apiVersion, oauthToken, restClient, connectTimeout, readTimeout, paginationPageSize, serializeNulls);
    }

    @Override
    public Optional<ExternalTool> getExternalToolInCourse(String courseId, Long toolId) throws IOException {
        return this.getExternalTool("courses", courseId, toolId);
    }

    @Override
    public Optional<ExternalTool> getExternalToolInAccount(String accountId, Long toolId) throws IOException {
        return this.getExternalTool("accounts", accountId, toolId);
    }

    private Optional<ExternalTool> getExternalTool(String objectType, String objectId, Long toolId) throws IOException {
        LOG.debug("Getting external tool {} from {} {}", new Object[]{toolId, objectType, objectId});
        if (StringUtils.isBlank((CharSequence)objectId) || toolId == null) {
            throw new IllegalArgumentException("course/account ID and tool ID cannot be blank");
        }
        String url = this.buildCanvasUrl(objectType + "/" + objectId + "/external_tools/" + toolId, Collections.emptyMap());
        return this.getFromCanvas(url);
    }

    @Override
    public List<ExternalTool> listExternalToolsInAccount(ListExternalToolsOptions options) throws IOException {
        return this.listExternalTools("accounts", options.getId(), options.getOptionsMap());
    }

    @Override
    public List<ExternalTool> listExternalToolsInCourse(ListExternalToolsOptions options) throws IOException {
        return this.listExternalTools("courses", options.getId(), options.getOptionsMap());
    }

    @Override
    public List<ExternalTool> listExternalToolsInGroup(ListExternalToolsOptions options) throws IOException {
        return this.listExternalTools("groups", options.getId(), options.getOptionsMap());
    }

    private List<ExternalTool> listExternalTools(String objectType, String objectId, Map<String, List<String>> optionsMap) throws IOException {
        LOG.debug("Getting list of external tools from {}: {}", (Object)objectType, (Object)objectId);
        String url = this.buildCanvasUrl(objectType + "/" + objectId + "/external_tools", optionsMap);
        return this.getListFromCanvas(url);
    }

    @Override
    public Optional<ExternalTool> createExternalToolInCourse(String courseId, ExternalTool tool) throws IOException {
        LOG.debug("Creating external tool \"{}\" in course {}", (Object)tool.getName(), (Object)courseId);
        String url = this.buildCanvasUrl("courses/" + courseId + "/external_tools", Collections.emptyMap());
        return this.createExternalTool(url, tool);
    }

    @Override
    public Optional<ExternalTool> createExternalToolInAccount(String accountId, ExternalTool tool) throws IOException {
        LOG.debug("Creating external tool \"{} \" in account {}", (Object)tool.getName(), (Object)accountId);
        String url = this.buildCanvasUrl("accounts/" + accountId + "/external_tools", Collections.emptyMap());
        return this.createExternalTool(url, tool);
    }

    private Optional<ExternalTool> createExternalTool(String url, ExternalTool tool) throws IOException {
        this.ensureToolValidForCreation(tool);
        Gson gson = GsonResponseParser.getDefaultGsonParser(this.serializeNulls);
        JsonObject toolJson = gson.toJsonTree((Object)tool).getAsJsonObject();
        Response response = this.canvasMessenger.sendJsonPostToCanvas(this.oauthToken, url, toolJson);
        return this.responseParser.parseToObject(ExternalTool.class, response);
    }

    @Override
    public Optional<ExternalTool> editExternalToolInCourse(String courseId, ExternalTool tool) throws IOException {
        LOG.debug("Editing external tool \"{}\" in course {}", (Object)tool.getName(), (Object)courseId);
        String url = this.buildCanvasUrl("courses/" + courseId + "/external_tools/" + tool.getId(), Collections.emptyMap());
        return this.editExternalTool(url, tool);
    }

    @Override
    public Optional<ExternalTool> editExternalToolInAccount(String accountId, ExternalTool tool) throws IOException {
        LOG.debug("Editing external tool \"{}\" in course {}", (Object)tool.getName(), (Object)accountId);
        String url = this.buildCanvasUrl("accounts/" + accountId + "/external_tools/" + tool.getId(), Collections.emptyMap());
        return this.editExternalTool(url, tool);
    }

    private Optional<ExternalTool> editExternalTool(String url, ExternalTool tool) throws IOException {
        if (tool.getId() == null) {
            throw new IllegalArgumentException("Tool being edited must have a tool ID");
        }
        Gson gson = GsonResponseParser.getDefaultGsonParser(this.serializeNulls);
        JsonObject toolJson = gson.toJsonTree((Object)tool).getAsJsonObject();
        Response response = this.canvasMessenger.sendJsonPutToCanvas(this.oauthToken, url, toolJson);
        return this.responseParser.parseToObject(ExternalTool.class, response);
    }

    @Override
    public Optional<ExternalTool> deleteExternalToolInCourse(String courseId, Long toolId) throws IOException {
        LOG.debug("Deleting external tool {} from course {}", (Object)toolId, (Object)courseId);
        String url = this.buildCanvasUrl("courses/" + courseId + "/external_tools/" + toolId, Collections.emptyMap());
        Response response = this.canvasMessenger.deleteFromCanvas(this.oauthToken, url, Collections.emptyMap());
        return this.responseParser.parseToObject(ExternalTool.class, response);
    }

    @Override
    public Optional<ExternalTool> deleteExternalToolInAccount(String accountId, Long toolId) throws IOException {
        LOG.debug("Deleting external tool {} from account {}", (Object)toolId, (Object)accountId);
        String url = this.buildCanvasUrl("accounts/" + accountId + "/external_tools/" + toolId, Collections.emptyMap());
        Response response = this.canvasMessenger.deleteFromCanvas(this.oauthToken, url, Collections.emptyMap());
        return this.responseParser.parseToObject(ExternalTool.class, response);
    }

    private void ensureToolValidForCreation(ExternalTool tool) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tool.getName(), tool.getPrivacyLevel(), tool.getConsumerKey(), tool.getSharedSecret()})) {
            throw new IllegalArgumentException("External tool requires all of the following for creation: name, privacy level, consumer key, shared secret");
        }
        if (StringUtils.isBlank((CharSequence)tool.getUrl()) && StringUtils.isBlank((CharSequence)tool.getDomain())) {
            throw new IllegalArgumentException("External tool requires either a URL or domain for creation");
        }
    }

    @Override
    protected Type listType() {
        return new TypeToken<List<ExternalTool>>(){}.getType();
    }

    @Override
    protected Class<ExternalTool> objectType() {
        return ExternalTool.class;
    }
}

