/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.gson.reflect.TypeToken;
import edu.ksu.canvas.impl.BaseImpl;
import edu.ksu.canvas.interfaces.FeatureFlagReader;
import edu.ksu.canvas.interfaces.FeatureFlagWriter;
import edu.ksu.canvas.model.FeatureFlag;
import edu.ksu.canvas.net.Response;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class FeatureFlagImpl
extends BaseImpl<FeatureFlag, FeatureFlagReader, FeatureFlagWriter>
implements FeatureFlagWriter,
FeatureFlagReader {
    public FeatureFlagImpl(String canvasBaseUrl, Integer apiVersion, OauthToken oauthToken, RestClient restClient, int connectTimeout, int readTimeout, Integer paginationPageSize, Boolean serializeNulls) {
        super(canvasBaseUrl, apiVersion, oauthToken, restClient, connectTimeout, readTimeout, paginationPageSize, serializeNulls);
    }

    @Override
    public Optional<FeatureFlag> updateCourseFeatureFlag(String courseId, String feature, FeatureFlag.State state) throws IOException {
        String url = this.buildCanvasUrl("courses/" + courseId + "/features/flags/" + feature, Collections.emptyMap());
        return this.updateFeatureFlag(url, state);
    }

    @Override
    public Optional<FeatureFlag> updateAccountFeatureFlag(String accountId, String feature, FeatureFlag.State state) throws IOException {
        String url = this.buildCanvasUrl("accounts/" + accountId + "/features/flags/" + feature, Collections.emptyMap());
        return this.updateFeatureFlag(url, state);
    }

    @Override
    public Optional<FeatureFlag> updateUserFeatureFlag(String userId, String feature, FeatureFlag.State state) throws IOException {
        String url = this.buildCanvasUrl("users/" + userId + "/features/flags/" + feature, Collections.emptyMap());
        return this.updateFeatureFlag(url, state);
    }

    private Optional<FeatureFlag> updateFeatureFlag(String url, FeatureFlag.State state) throws IOException {
        Map<String, List<String>> params = Collections.singletonMap("state", Collections.singletonList(state.name()));
        return this.getFeatureFlag(this.canvasMessenger.putToCanvas(this.oauthToken, url, params));
    }

    @Override
    protected Type listType() {
        return new TypeToken<List<FeatureFlag>>(){}.getType();
    }

    @Override
    protected Class<FeatureFlag> objectType() {
        return FeatureFlag.class;
    }

    @Override
    public Optional<FeatureFlag> getCourseFeatureFlag(String courseId, String feature) throws IOException {
        String url = this.buildCanvasUrl("courses/" + courseId + "/features/flags/" + feature, Collections.emptyMap());
        return this.getFeatureFlag(this.canvasMessenger.getSingleResponseFromCanvas(this.oauthToken, url));
    }

    @Override
    public Optional<FeatureFlag> getAccountFeatureFlag(String accountId, String feature) throws IOException {
        String url = this.buildCanvasUrl("accounts/" + accountId + "/features/flags/" + feature, Collections.emptyMap());
        return this.getFeatureFlag(this.canvasMessenger.getSingleResponseFromCanvas(this.oauthToken, url));
    }

    @Override
    public Optional<FeatureFlag> getUserFeatureFlag(String userId, String feature) throws IOException {
        String url = this.buildCanvasUrl("users/" + userId + "/features/flags/" + feature, Collections.emptyMap());
        return this.getFeatureFlag(this.canvasMessenger.getSingleResponseFromCanvas(this.oauthToken, url));
    }

    private Optional<FeatureFlag> getFeatureFlag(Response singleResponseFromCanvas) {
        Response response = singleResponseFromCanvas;
        return this.responseParser.parseToObject(FeatureFlag.class, response);
    }
}

