/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.gson.reflect.TypeToken;
import edu.ksu.canvas.impl.BaseImpl;
import edu.ksu.canvas.interfaces.CanvasWriter;
import edu.ksu.canvas.interfaces.ModuleReader;
import edu.ksu.canvas.model.Module;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import edu.ksu.canvas.requestOptions.ListModulesOptions;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleImpl
extends BaseImpl<Module, ModuleReader, CanvasWriter>
implements ModuleReader {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleImpl.class);

    public ModuleImpl(String canvasBaseUrl, Integer apiVersion, OauthToken oauthToken, RestClient restClient, int connectTimeout, int readTimeout, Integer paginationPageSize, Boolean serializeNulls) {
        super(canvasBaseUrl, apiVersion, oauthToken, restClient, connectTimeout, readTimeout, paginationPageSize, serializeNulls);
    }

    @Override
    public List<Module> getModulesInCourse(ListModulesOptions options) throws IOException {
        LOG.debug("Retrieving modules for course {}", (Object)options.getCourseId());
        String url = this.buildCanvasUrl(String.format("courses/%d/modules", options.getCourseId()), options.getOptionsMap());
        return this.getListFromCanvas(url);
    }

    @Override
    protected Class<Module> objectType() {
        return Module.class;
    }

    @Override
    protected Type listType() {
        return new TypeToken<List<Module>>(){}.getType();
    }
}

