/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.gson.reflect.TypeToken;
import edu.ksu.canvas.impl.BaseImpl;
import edu.ksu.canvas.interfaces.CanvasWriter;
import edu.ksu.canvas.interfaces.SelectiveDataReader;
import edu.ksu.canvas.model.SelectiveData;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import edu.ksu.canvas.requestOptions.GetSelectiveDataOptions;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectiveDataImpl
extends BaseImpl<SelectiveData, SelectiveDataReader, CanvasWriter>
implements SelectiveDataReader {
    private static final Logger LOG = LoggerFactory.getLogger(SelectiveDataImpl.class);

    public SelectiveDataImpl(String canvasBaseUrl, Integer apiVersion, OauthToken oauthToken, RestClient restClient, int connectTimeout, int readTimeout, Integer paginationPageSize, Boolean serializeNulls) {
        super(canvasBaseUrl, apiVersion, oauthToken, restClient, connectTimeout, readTimeout, paginationPageSize, serializeNulls);
    }

    @Override
    public List<SelectiveData> getCourseSelectiveDataFromMigration(GetSelectiveDataOptions options) throws IOException {
        LOG.debug("listing the items available for a content migration for the course");
        String url = this.buildCanvasUrl("courses/" + options.getItemId() + "/content_migrations/" + options.getMigrationId().toString() + "/selective_data", options.getOptionsMap());
        return this.getListFromCanvas(url);
    }

    @Override
    public List<SelectiveData> getUserSelectiveDataFromMigration(GetSelectiveDataOptions options) throws IOException {
        LOG.debug("listing the items available for a content migration for the user");
        String url = this.buildCanvasUrl("users/" + options.getItemId() + "/content_migrations/" + options.getMigrationId().toString() + "/selective_data", options.getOptionsMap());
        return this.getListFromCanvas(url);
    }

    @Override
    public List<SelectiveData> getGroupSelectiveDataFromMigration(GetSelectiveDataOptions options) throws IOException {
        LOG.debug("listing the items available for a content migration for the group");
        String url = this.buildCanvasUrl("groups/" + options.getItemId() + "/content_migrations/" + options.getMigrationId().toString() + "/selective_data", options.getOptionsMap());
        return this.getListFromCanvas(url);
    }

    @Override
    public List<SelectiveData> getAccountSelectiveDataFromMigration(GetSelectiveDataOptions options) throws IOException {
        LOG.debug("listing the items available for a content migration for the account");
        String url = this.buildCanvasUrl("accounts/" + options.getItemId() + "/content_migrations/" + options.getMigrationId().toString() + "/selective_data", options.getOptionsMap());
        return this.getListFromCanvas(url);
    }

    @Override
    protected Type listType() {
        return new TypeToken<List<SelectiveData>>(){}.getType();
    }

    @Override
    protected Class<SelectiveData> objectType() {
        return SelectiveData.class;
    }
}

