/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.gson.reflect.TypeToken;
import edu.ksu.canvas.impl.BaseImpl;
import edu.ksu.canvas.interfaces.TabReader;
import edu.ksu.canvas.interfaces.TabWriter;
import edu.ksu.canvas.model.Tab;
import edu.ksu.canvas.net.Response;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import edu.ksu.canvas.requestOptions.UpdateCourseTabOptions;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabImpl
extends BaseImpl<Tab, TabReader, TabWriter>
implements TabReader,
TabWriter {
    private static final Logger LOG = LoggerFactory.getLogger(TabImpl.class);

    public TabImpl(String canvasBaseUrl, Integer apiVersion, OauthToken oauthToken, RestClient restClient, int connectTimeout, int readTimeout, Integer paginationPageSize, Boolean serializeNulls) {
        super(canvasBaseUrl, apiVersion, oauthToken, restClient, connectTimeout, readTimeout, paginationPageSize, serializeNulls);
    }

    @Override
    public List<Tab> listAvailableCourseTabs(String courseId, boolean includeExternalTools) throws IOException {
        LOG.debug("Retrieving tabs for course {}", (Object)courseId);
        String url = this.buildCanvasUrl(String.format("courses/%s/tabs", courseId), Collections.emptyMap());
        return this.getListFromCanvas(url);
    }

    @Override
    public Optional<Tab> updateCourseTab(UpdateCourseTabOptions options) throws IOException {
        LOG.debug("Updating tab {} for course {}", (Object)options.getCourseId(), (Object)options.getTabId());
        String url = this.buildCanvasUrl(String.format("courses/%s/tabs/%s", options.getCourseId(), options.getTabId()), Collections.emptyMap());
        Response response = this.canvasMessenger.putToCanvas(this.oauthToken, url, options.getOptionsMap());
        return this.responseParser.parseToObject(Tab.class, response);
    }

    @Override
    protected Class<Tab> objectType() {
        return Tab.class;
    }

    @Override
    protected Type listType() {
        return new TypeToken<List<Tab>>(){}.getType();
    }
}

