/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import edu.ksu.canvas.annotation.CanvasField;
import edu.ksu.canvas.annotation.CanvasObject;
import edu.ksu.canvas.impl.GsonResponseParser;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCanvasModel {
    private static final Logger LOG = LoggerFactory.getLogger(BaseCanvasModel.class);

    public Map<String, List<String>> toPostMap(boolean includeNulls) {
        Class<?> clazz = this.getClass();
        HashMap<String, List<String>> postMap = new HashMap<String, List<String>>();
        for (Method method : clazz.getMethods()) {
            CanvasField canvasFieldAnnotation = method.getAnnotation(CanvasField.class);
            if (canvasFieldAnnotation == null || canvasFieldAnnotation.postKey() == null) continue;
            String postKey = this.getPostKey(canvasFieldAnnotation);
            try {
                List<String> fieldValues = this.getFieldValues(method);
                if ((fieldValues == null || fieldValues.isEmpty()) && !includeNulls) continue;
                if (postMap.containsKey(postKey)) {
                    ((List)postMap.get(postKey)).addAll(fieldValues);
                    continue;
                }
                postMap.put(postKey, fieldValues);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                String message = "Could not access Canvas model getter for" + postKey;
                LOG.error(message, (Throwable)e);
                throw new IllegalStateException(message, e);
            }
        }
        return postMap;
    }

    public JsonObject toJsonObject(Boolean serializeNulls) {
        Class<?> clazz = this.getClass();
        CanvasObject canvasObjectAnnotation = clazz.getAnnotation(CanvasObject.class);
        if (canvasObjectAnnotation == null || canvasObjectAnnotation.postKey() == null) {
            throw new IllegalArgumentException("Object to wrap must have a CanvasObject annotation with a postKey");
        }
        String objectPostKey = canvasObjectAnnotation.postKey();
        JsonElement element = GsonResponseParser.getDefaultGsonParser(serializeNulls).toJsonTree((Object)this);
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(objectPostKey, element);
        return jsonObject;
    }

    private String getPostKey(CanvasField canvasFieldAnnotation) {
        if (!canvasFieldAnnotation.array()) {
            return canvasFieldAnnotation.postKey();
        }
        return this.makeArrayPostKey(canvasFieldAnnotation);
    }

    private String makeArrayPostKey(CanvasField canvasFieldAnnotation) {
        if (!canvasFieldAnnotation.overrideObjectKey().isEmpty()) {
            return canvasFieldAnnotation.overrideObjectKey() + "[" + canvasFieldAnnotation.postKey() + "]";
        }
        CanvasObject canvasObjectAnnotation = this.getClass().getAnnotation(CanvasObject.class);
        if (canvasObjectAnnotation == null || canvasObjectAnnotation.postKey() == null) {
            throw new IllegalArgumentException("CanvasObject does not contain postKey for " + this.getClass().getName());
        }
        return canvasObjectAnnotation.postKey() + "[" + canvasFieldAnnotation.postKey() + "]";
    }

    private List<String> getFieldValues(Method getter) throws InvocationTargetException, IllegalAccessException {
        ArrayList<String> fieldValues = new ArrayList<String>(1);
        Class<?> returnType = getter.getReturnType();
        Object returnValue = getter.invoke((Object)this, new Object[0]);
        if (returnValue == null) {
            return Collections.emptyList();
        }
        if (Iterable.class.isAssignableFrom(returnType)) {
            for (Object value : (Iterable)returnValue) {
                fieldValues.add(String.valueOf(value));
            }
        } else {
            fieldValues.add(String.valueOf(returnValue));
        }
        return fieldValues;
    }
}

