/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.net;

import edu.ksu.canvas.exception.InvalidOauthTokenException;
import edu.ksu.canvas.net.Response;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.net.SimpleRestClient;
import edu.ksu.canvas.oauth.OauthToken;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshingRestClient
implements RestClient {
    private static final Logger LOG = LoggerFactory.getLogger(RefreshingRestClient.class);
    private RestClient restClient = new SimpleRestClient();

    @Override
    public Response sendApiGet(@NotNull OauthToken token, @NotNull String url, int connectTimeout, int readTimeout) throws IOException {
        try {
            return this.restClient.sendApiGet(token, url, connectTimeout, readTimeout);
        }
        catch (InvalidOauthTokenException e) {
            LOG.debug("Caught invalidOauthToken from " + url);
            token.refresh();
            return this.restClient.sendApiGet(token, url, connectTimeout, readTimeout);
        }
    }

    @Override
    public Response sendJsonPost(@NotNull OauthToken token, @NotNull String url, String json, int connectTimeout, int readTimeout) throws IOException {
        try {
            return this.restClient.sendJsonPost(token, url, json, connectTimeout, readTimeout);
        }
        catch (InvalidOauthTokenException e) {
            LOG.debug("Caught invalidOauthToken from " + url);
            token.refresh();
            return this.restClient.sendJsonPost(token, url, json, connectTimeout, readTimeout);
        }
    }

    @Override
    public Response sendJsonPut(@NotNull OauthToken token, @NotNull String url, String json, int connectTimeout, int readTimeout) throws IOException {
        try {
            return this.restClient.sendJsonPut(token, url, json, connectTimeout, readTimeout);
        }
        catch (InvalidOauthTokenException e) {
            LOG.debug("Caught invalidOauthToken from " + url);
            token.refresh();
            return this.restClient.sendJsonPut(token, url, json, connectTimeout, readTimeout);
        }
    }

    @Override
    public Response sendApiPost(@NotNull OauthToken token, @NotNull String url, Map<String, List<String>> postParameters, int connectTimeout, int readTimeout) throws InvalidOauthTokenException, IOException {
        try {
            return this.restClient.sendApiPost(token, url, postParameters, connectTimeout, readTimeout);
        }
        catch (InvalidOauthTokenException e) {
            LOG.debug("Caught invalidOauthToken from " + url);
            token.refresh();
            return this.restClient.sendApiPost(token, url, postParameters, connectTimeout, readTimeout);
        }
    }

    @Override
    public Response sendApiPostFile(@NotNull OauthToken token, @NotNull String url, Map<String, List<String>> postParameters, String fileParameter, String filePath, InputStream is, int connectTimeout, int readTimeout) throws InvalidOauthTokenException, IOException {
        try {
            return this.restClient.sendApiPostFile(token, url, postParameters, fileParameter, filePath, is, connectTimeout, readTimeout);
        }
        catch (InvalidOauthTokenException e) {
            LOG.debug("Caught invalidOauthToken from " + url);
            token.refresh();
            return this.restClient.sendApiPostFile(token, url, postParameters, fileParameter, filePath, is, connectTimeout, readTimeout);
        }
    }

    @Override
    public Response sendApiDelete(@NotNull OauthToken token, @NotNull String url, Map<String, List<String>> deleteParameters, int connectTimeout, int readTimeout) throws InvalidOauthTokenException, IOException {
        try {
            return this.restClient.sendApiDelete(token, url, deleteParameters, connectTimeout, readTimeout);
        }
        catch (InvalidOauthTokenException e) {
            LOG.debug("Caught invalidOauthToken from " + url);
            token.refresh();
            return this.restClient.sendApiDelete(token, url, deleteParameters, connectTimeout, readTimeout);
        }
    }

    @Override
    public Response sendApiPut(@NotNull OauthToken token, @NotNull String url, Map<String, List<String>> putParameters, int connectTimeout, int readTimeout) throws InvalidOauthTokenException, IOException {
        try {
            return this.restClient.sendApiPut(token, url, putParameters, connectTimeout, readTimeout);
        }
        catch (InvalidOauthTokenException e) {
            LOG.debug("Caught invalidOauthToken from " + url);
            token.refresh();
            return this.restClient.sendApiPut(token, url, putParameters, connectTimeout, readTimeout);
        }
    }

    @Override
    public String sendUpload(String uploadUrl, Map<String, List<String>> params, InputStream in, String filename, int connectTimeout, int readTimeout) throws IOException {
        return this.restClient.sendUpload(uploadUrl, params, in, filename, connectTimeout, readTimeout);
    }
}

