/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.net;

import com.google.gson.Gson;
import edu.ksu.canvas.errors.ErrorHandler;
import edu.ksu.canvas.errors.GenericErrorHandler;
import edu.ksu.canvas.errors.UserErrorHandler;
import edu.ksu.canvas.exception.CanvasException;
import edu.ksu.canvas.exception.InvalidOauthTokenException;
import edu.ksu.canvas.exception.ObjectNotFoundException;
import edu.ksu.canvas.exception.RateLimitException;
import edu.ksu.canvas.exception.RetriableException;
import edu.ksu.canvas.exception.ThrottlingException;
import edu.ksu.canvas.exception.UnauthorizedException;
import edu.ksu.canvas.impl.GsonResponseParser;
import edu.ksu.canvas.model.status.CanvasErrorResponse;
import edu.ksu.canvas.net.Response;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRestClient
implements RestClient {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleRestClient.class);
    private List<ErrorHandler> errorHandlers = new ArrayList<ErrorHandler>();

    public SimpleRestClient() {
        this.errorHandlers.add(new UserErrorHandler());
        this.errorHandlers.add(new GenericErrorHandler());
    }

    @Override
    public Response sendApiGet(@NotNull OauthToken token, @NotNull String url, int connectTimeout, int readTimeout) throws IOException {
        LOG.debug("Sending GET request to URL: " + url);
        Long beginTime = System.currentTimeMillis();
        Response response = new Response();
        try (CloseableHttpClient httpClient = this.createHttpClient(connectTimeout, readTimeout);){
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("Authorization", "Bearer " + token.getAccessToken());
            try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);){
                String linkHeaderValue;
                response.setContent(this.handleResponse((HttpResponse)httpResponse, (HttpRequestBase)httpGet));
                response.setResponseCode(httpResponse.getStatusLine().getStatusCode());
                Long endTime = System.currentTimeMillis();
                LOG.debug("GET call took: " + (endTime - beginTime) + "ms");
                Header linkHeader = httpResponse.getFirstHeader("Link");
                String string = linkHeaderValue = linkHeader == null ? null : httpResponse.getFirstHeader("Link").getValue();
                if (linkHeaderValue == null) {
                    Response response2 = response;
                    return response2;
                }
                List<String> links = Arrays.asList(linkHeaderValue.split(","));
                for (String link : links) {
                    if (!link.contains("rel=\"next\"")) continue;
                    LOG.debug("response has more pages");
                    String nextLink = link.substring(1, link.indexOf(59) - 1);
                    response.setNextLink(nextLink);
                }
            }
        }
        return response;
    }

    @Override
    public Response sendJsonPut(OauthToken token, String url, String json, int connectTimeout, int readTimeout) throws IOException {
        return this.sendJsonPostOrPut(token, url, json, connectTimeout, readTimeout, "PUT");
    }

    @Override
    public Response sendJsonPost(OauthToken token, String url, String json, int connectTimeout, int readTimeout) throws IOException {
        return this.sendJsonPostOrPut(token, url, json, connectTimeout, readTimeout, "POST");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response sendJsonPostOrPut(OauthToken token, String url, String json, int connectTimeout, int readTimeout, String method) throws IOException {
        HttpPost action;
        LOG.debug("Sending JSON " + method + " to URL: " + url);
        Response response = new Response();
        CloseableHttpClient httpClient = this.createHttpClient(connectTimeout, readTimeout);
        if ("POST".equals(method)) {
            action = new HttpPost(url);
        } else if ("PUT".equals(method)) {
            action = new HttpPut(url);
        } else {
            throw new IllegalArgumentException("Method must be either POST or PUT");
        }
        Long beginTime = System.currentTimeMillis();
        action.setHeader("Authorization", "Bearer " + token.getAccessToken());
        StringEntity requestBody = new StringEntity(json, ContentType.APPLICATION_JSON);
        action.setEntity((HttpEntity)requestBody);
        try {
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)action);
            String content = this.handleResponse(httpResponse, (HttpRequestBase)action);
            response.setContent(content);
            response.setResponseCode(httpResponse.getStatusLine().getStatusCode());
            Long endTime = System.currentTimeMillis();
            LOG.debug("POST call took: " + (endTime - beginTime) + "ms");
        }
        finally {
            action.releaseConnection();
        }
        return response;
    }

    @Override
    public Response sendApiPost(OauthToken token, String url, Map<String, List<String>> postParameters, int connectTimeout, int readTimeout) throws InvalidOauthTokenException, IOException {
        LOG.debug("Sending API POST request to URL: " + url);
        Response response = new Response();
        CloseableHttpClient httpClient = this.createHttpClient(connectTimeout, readTimeout);
        Long beginTime = System.currentTimeMillis();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Authorization", "Bearer " + token.getAccessToken());
        List<NameValuePair> params = SimpleRestClient.convertParameters(postParameters);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
        String content = this.handleResponse(httpResponse, (HttpRequestBase)httpPost);
        response.setContent(content);
        response.setResponseCode(httpResponse.getStatusLine().getStatusCode());
        Long endTime = System.currentTimeMillis();
        LOG.debug("POST call took: " + (endTime - beginTime) + "ms");
        return response;
    }

    @Override
    public Response sendApiPostFile(OauthToken token, String url, Map<String, List<String>> postParameters, String fileParameter, String filePath, InputStream is, int connectTimeout, int readTimeout) throws InvalidOauthTokenException, IOException {
        LOG.debug("Sending API POST file request to URL: " + url);
        Response response = new Response();
        CloseableHttpClient httpClient = this.createHttpClient(connectTimeout, readTimeout);
        Long beginTime = System.currentTimeMillis();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Authorization", "Bearer " + token.getAccessToken());
        List<NameValuePair> params = SimpleRestClient.convertParameters(postParameters);
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        entityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        if (is == null) {
            FileBody fileBody = new FileBody(new File(filePath));
            entityBuilder.addPart(fileParameter, (ContentBody)fileBody);
        } else {
            entityBuilder.addPart(fileParameter, (ContentBody)new InputStreamBody(is, filePath));
        }
        for (NameValuePair param : params) {
            entityBuilder.addTextBody(param.getName(), param.getValue());
        }
        httpPost.setEntity(entityBuilder.build());
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
        String content = this.handleResponse(httpResponse, (HttpRequestBase)httpPost);
        response.setContent(content);
        response.setResponseCode(httpResponse.getStatusLine().getStatusCode());
        Long endTime = System.currentTimeMillis();
        LOG.debug("POST file call took: " + (endTime - beginTime) + "ms");
        return response;
    }

    @Override
    public Response sendApiPut(OauthToken token, String url, Map<String, List<String>> putParameters, int connectTimeout, int readTimeout) throws InvalidOauthTokenException, IOException {
        LOG.debug("Sending API PUT request to URL: " + url);
        Response response = new Response();
        CloseableHttpClient httpClient = this.createHttpClient(connectTimeout, readTimeout);
        Long beginTime = System.currentTimeMillis();
        HttpPut httpPut = new HttpPut(url);
        httpPut.setHeader("Authorization", "Bearer " + token.getAccessToken());
        List<NameValuePair> params = SimpleRestClient.convertParameters(putParameters);
        httpPut.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPut);
        String content = this.handleResponse(httpResponse, (HttpRequestBase)httpPut);
        response.setContent(content);
        response.setResponseCode(httpResponse.getStatusLine().getStatusCode());
        Long endTime = System.currentTimeMillis();
        LOG.debug("PUT call took: " + (endTime - beginTime) + "ms");
        return response;
    }

    @Override
    public Response sendApiDelete(OauthToken token, String url, Map<String, List<String>> deleteParameters, int connectTimeout, int readTimeout) throws InvalidOauthTokenException, IOException {
        LOG.debug("Sending API DELETE request to URL: " + url);
        Response response = new Response();
        Long beginTime = System.currentTimeMillis();
        CloseableHttpClient httpClient = this.createHttpClient(connectTimeout, readTimeout);
        class HttpDeleteWithBody
        extends HttpPost {
            HttpDeleteWithBody() {
            }

            public String getMethod() {
                return "DELETE";
            }
        }
        HttpDeleteWithBody httpDelete = new HttpDeleteWithBody();
        httpDelete.setURI(URI.create(url));
        httpDelete.setHeader("Authorization", "Bearer " + token.getAccessToken());
        List<NameValuePair> params = SimpleRestClient.convertParameters(deleteParameters);
        httpDelete.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpDelete);
        String content = this.handleResponse(httpResponse, (HttpRequestBase)httpDelete);
        response.setContent(content);
        response.setResponseCode(httpResponse.getStatusLine().getStatusCode());
        Long endTime = System.currentTimeMillis();
        LOG.debug("DELETE call took: " + (endTime - beginTime) + "ms");
        return response;
    }

    @Override
    public String sendUpload(String uploadUrl, Map<String, List<String>> params, InputStream in, String filename, int connectTimeout, int readTimeout) throws IOException {
        CloseableHttpClient client = this.buildHttpClient(connectTimeout, readTimeout).disableRedirectHandling().build();
        HttpPost httpPost = new HttpPost(uploadUrl);
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        for (Map.Entry<String, List<String>> entry : params.entrySet()) {
            for (String value : entry.getValue()) {
                entityBuilder.addTextBody(entry.getKey(), value);
            }
        }
        InputStreamBody fileBody = new InputStreamBody(in, filename);
        entityBuilder.addPart("file", (ContentBody)fileBody);
        httpPost.setEntity(entityBuilder.build());
        HttpResponse httpResponse = client.execute((HttpUriRequest)httpPost);
        this.checkHeaders(httpResponse, (HttpRequestBase)httpPost, true);
        int httpStatus = httpResponse.getStatusLine().getStatusCode();
        if (httpStatus == 201 || 300 <= httpStatus && httpStatus <= 399) {
            Header location = httpResponse.getFirstHeader("Location");
            if (location != null) {
                return location.getValue();
            }
            throw new CanvasException("No location to redirect to when uploading file: " + httpStatus, uploadUrl);
        }
        throw new CanvasException("Bad status when uploading file: " + httpStatus, uploadUrl);
    }

    private void checkHeaders(HttpResponse httpResponse, HttpRequestBase request, boolean allowRedirect) {
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        double rateLimitThreshold = 0.1;
        double xRateCost = 0.0;
        double xRateLimitRemaining = 0.0;
        try {
            xRateCost = Double.parseDouble(httpResponse.getFirstHeader("x-request-cost").getValue());
            xRateLimitRemaining = Double.parseDouble(httpResponse.getFirstHeader("x-rate-limit-remaining").getValue());
            if (xRateLimitRemaining < rateLimitThreshold) {
                LOG.error("Canvas API rate limit exceeded. Bucket quota: " + xRateLimitRemaining + " Cost: " + xRateCost + " Threshold: " + rateLimitThreshold + " HTTP status: " + statusCode + " Requested URL: " + request.getURI());
                throw new RateLimitException(this.extractErrorMessageFromResponse(httpResponse), String.valueOf(request.getURI()));
            }
        }
        catch (NullPointerException e) {
            LOG.debug("Rate not being limited: " + e);
        }
        if (statusCode == 401) {
            if (httpResponse.containsHeader("WWW-Authenticate")) {
                LOG.debug("User's token is invalid. It might need refreshing");
                throw new InvalidOauthTokenException();
            }
            LOG.error("User is not authorized to perform this action");
            throw new UnauthorizedException();
        }
        if (statusCode == 403) {
            LOG.error("Canvas has throttled this request. Requested URL: " + request.getURI());
            throw new ThrottlingException(this.extractErrorMessageFromResponse(httpResponse), String.valueOf(request.getURI()));
        }
        if (statusCode == 404) {
            LOG.error("Object not found in Canvas. Requested URL: " + request.getURI());
            throw new ObjectNotFoundException(this.extractErrorMessageFromResponse(httpResponse), String.valueOf(request.getURI()));
        }
        if (statusCode == 504) {
            LOG.error("504 Gateway Time-out while requesting: " + request.getURI());
            throw new RetriableException("status code: 504, reason phrase: Gateway Time-out", String.valueOf(request.getURI()));
        }
        if (statusCode < 200 || statusCode > (allowRedirect ? 399 : 299) && statusCode <= 499) {
            LOG.error("HTTP status " + statusCode + " returned from " + request.getURI());
            this.handleError(request, httpResponse);
        }
    }

    private void handleError(HttpRequestBase httpRequest, HttpResponse httpResponse) {
        for (ErrorHandler handler : this.errorHandlers) {
            if (!handler.shouldHandle((HttpRequest)httpRequest, httpResponse)) continue;
            handler.handle((HttpRequest)httpRequest, httpResponse);
        }
        String canvasErrorString = this.extractErrorMessageFromResponse(httpResponse);
        throw new CanvasException(canvasErrorString, String.valueOf(httpRequest.getURI()));
    }

    private String extractErrorMessageFromResponse(HttpResponse response) {
        String message;
        block3: {
            String contentType = response.getEntity().getContentType().getValue();
            message = null;
            if (contentType.contains("application/json")) {
                Gson gson = GsonResponseParser.getDefaultGsonParser(false);
                String responseBody = null;
                try {
                    responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                    LOG.error("Body of error response from Canvas: " + responseBody);
                    CanvasErrorResponse errorResponse = (CanvasErrorResponse)gson.fromJson(responseBody, CanvasErrorResponse.class);
                    List<CanvasErrorResponse.ErrorMessage> errors = errorResponse.getErrors();
                    message = errors != null ? errors.stream().map(CanvasErrorResponse.ErrorMessage::getMessage).collect(Collectors.joining(", ")) : responseBody;
                }
                catch (Exception e) {
                    if (!StringUtils.isNotBlank((CharSequence)responseBody)) break block3;
                    message = responseBody;
                }
            }
        }
        return message;
    }

    private String handleResponse(HttpResponse httpResponse, HttpRequestBase request) throws IOException {
        this.checkHeaders(httpResponse, request, false);
        return new BasicResponseHandler().handleResponse(httpResponse);
    }

    private CloseableHttpClient createHttpClient(int connectTimeout, int readTimeout) {
        return this.buildHttpClient(connectTimeout, readTimeout).build();
    }

    private HttpClientBuilder buildHttpClient(int connectTimeout, int readTimeout) {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(connectTimeout).setSocketTimeout(readTimeout).setCookieSpec("standard").build();
        return HttpClientBuilder.create().setDefaultRequestConfig(config);
    }

    private static List<NameValuePair> convertParameters(Map<String, List<String>> parameterMap) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (parameterMap == null) {
            return params;
        }
        for (Map.Entry<String, List<String>> param : parameterMap.entrySet()) {
            String key = param.getKey();
            if (param.getValue() == null || param.getValue().isEmpty()) {
                params.add((NameValuePair)new BasicNameValuePair(key, null));
                LOG.debug("key: " + key + "\tempty value");
            }
            for (String value : param.getValue()) {
                params.add((NameValuePair)new BasicNameValuePair(key, value));
                LOG.debug("key: " + key + "\tvalue: " + value);
            }
        }
        return params;
    }
}

