/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.oauth;

import com.google.gson.Gson;
import edu.ksu.canvas.impl.GsonResponseParser;
import edu.ksu.canvas.oauth.TokenRefreshResponse;
import java.io.IOException;
import java.io.Serializable;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OauthTokenRefresher
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(OauthTokenRefresher.class);
    private static final int TIMEOUT_SECONDS = 10;
    private final String clientId;
    private final String clientSecret;
    private final String canvasUrl;

    public OauthTokenRefresher(String clientId, String clientSecret, String canvasUrl) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.canvasUrl = canvasUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenRefreshResponse getNewToken(String refreshToken) throws IOException {
        LOG.debug("Getting a fresh OAuth access token");
        RequestConfig config = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(10000).build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
        String url = this.canvasUrl + "/login/oauth2/token?grant_type=refresh_token&client_id=" + this.clientId + "&client_secret=" + this.clientSecret + "&refresh_token=" + refreshToken;
        HttpPost postRequest = new HttpPost(url);
        try {
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)postRequest);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode == 401) {
                LOG.error("Unauthorized refresh token request. Wrong client_id or secret?");
                TokenRefreshResponse tokenRefreshResponse = null;
                return tokenRefreshResponse;
            }
            if (statusCode != 200) {
                String errorBody;
                LOG.error("Non-200 status code ( " + statusCode + " )returned while requesting an access token at URL " + url);
                HttpEntity errorEntity = httpResponse.getEntity();
                if (errorEntity != null) {
                    errorBody = EntityUtils.toString((HttpEntity)errorEntity);
                    LOG.error("Response from Canvas: " + errorBody);
                }
                errorBody = null;
                return errorBody;
            }
            HttpEntity entity = httpResponse.getEntity();
            String responseBody = EntityUtils.toString((HttpEntity)entity);
            Gson gson = GsonResponseParser.getDefaultGsonParser(false);
            TokenRefreshResponse tokenRefreshResponse = (TokenRefreshResponse)gson.fromJson(responseBody, TokenRefreshResponse.class);
            return tokenRefreshResponse;
        }
        finally {
            postRequest.releaseConnection();
            httpClient.close();
        }
    }
}

