/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.requestOptions;

import edu.ksu.canvas.requestOptions.CreateContentMigrationOptions;
import java.util.Date;

public class CreateCourseContentMigrationOptions
extends CreateContentMigrationOptions {
    private final String destinationCourseId;
    private final boolean selectiveImport;

    public CreateCourseContentMigrationOptions(String destinationCourseId, String sourceCourseId, CreateContentMigrationOptions.MigrationType migrationType, boolean selectiveImport, String ... selectedData) {
        super(sourceCourseId, migrationType);
        this.destinationCourseId = destinationCourseId;
        this.selectiveImport = selectiveImport;
        this.addSingleItem("selective_import", Boolean.toString(selectiveImport));
        for (String item : selectedData) {
            this.addSingleItem(item, "1");
        }
    }

    public String getDestinationCourseId() {
        return this.destinationCourseId;
    }

    public boolean isSelectiveImport() {
        return this.selectiveImport;
    }

    public CreateContentMigrationOptions questionBank(Long questionBankId) {
        this.addSingleItem("settings[question_bank_id]", questionBankId.toString());
        return this;
    }

    public CreateContentMigrationOptions questionBankName(String questionBankName) {
        this.addSingleItem("settings[question_bank_name]", questionBankName);
        return this;
    }

    public CreateContentMigrationOptions overwriteQuizzes(Boolean overwriteQuizzes) {
        this.addSingleItem("settings[overwrite_quizzes]", overwriteQuizzes.toString());
        return this;
    }

    public CreateContentMigrationOptions insertIntoModule(Long insertIntoModuleId) {
        this.addSingleItem("settings[insert_into_module_id]", insertIntoModuleId.toString());
        return this;
    }

    public CreateContentMigrationOptions insertIntoModuleType(String insertIntoModuleType) {
        this.addSingleItem("settings[insert_into_module_type]", insertIntoModuleType);
        return this;
    }

    public CreateContentMigrationOptions insertIntoModulePosition(Long insertIntoModulePosition) {
        this.addSingleItem("settings[insert_into_module_position]", insertIntoModulePosition.toString());
        return this;
    }

    public CreateContentMigrationOptions moveToAssignmentGroup(Long moveToAssignmentGroup) {
        this.addSingleItem("settings[move_to_assignment_group_id]", moveToAssignmentGroup.toString());
        return this;
    }

    public CreateContentMigrationOptions shiftDates(Boolean shiftDates) {
        this.addSingleItem("date_shift_options[shift_dates]", shiftDates.toString());
        return this;
    }

    public CreateContentMigrationOptions removeDates(Boolean removeDates) {
        this.addSingleItem("date_shift_options[remove_dates]", removeDates.toString());
        return this;
    }

    public CreateContentMigrationOptions oldStartDate(Date oldStartDate) {
        this.addSingleItem("date_shift_options[old_start_date]", oldStartDate.toString());
        return this;
    }

    public CreateContentMigrationOptions oldEndDate(Date oldEndDate) {
        this.addSingleItem("date_shift_options[old_end_date]", oldEndDate.toString());
        return this;
    }

    public CreateContentMigrationOptions newStartDate(Date newStartDate) {
        this.addSingleItem("date_shift_options[new_start_date]", newStartDate.toString());
        return this;
    }

    public CreateContentMigrationOptions newEndDate(Date newEndDate) {
        this.addSingleItem("date_shift_options[new_end_date]", newEndDate.toString());
        return this;
    }

    public CreateContentMigrationOptions daySubstitutions(Integer dayX, Integer newDay) {
        this.addSingleItem("date_shift_options[day_substitutions][" + dayX + "]", newDay.toString());
        return this;
    }
}

