/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.requestOptions;

import edu.ksu.canvas.requestOptions.BaseOptions;
import java.io.InputStream;

public class CreateSisImportOptions
extends BaseOptions {
    public static final String ATTACHMENT = "attachment";
    private final String accountId;
    private final String filePath;
    private final InputStream is;
    private final ImportType importType;

    public CreateSisImportOptions(String accountId, String filePath, ImportType importType, String diffingDataSetIdentifier, InputStream is) {
        this(accountId, filePath, importType, diffingDataSetIdentifier, is, false);
    }

    public CreateSisImportOptions(String accountId, String filePath, ImportType importType, String diffingDataSetIdentifier, InputStream is, boolean overrideSisStickiness) {
        this.accountId = accountId;
        this.importType = importType;
        this.filePath = filePath;
        this.is = is;
        this.addSingleItem("import_type", importType.toString().toLowerCase());
        if (diffingDataSetIdentifier != null) {
            this.addSingleItem("diffing_data_set_identifier", diffingDataSetIdentifier);
        }
        if (overrideSisStickiness) {
            this.addSingleItem("override_sis_stickiness", Boolean.toString(overrideSisStickiness));
        }
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public ImportType getImportType() {
        return this.importType;
    }

    public static enum ImportType {
        instructure_csv;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

