/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.requestOptions;

import edu.ksu.canvas.requestOptions.BaseOptions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ListAssignmentGroupOptions
extends BaseOptions {
    private String courseId;

    public ListAssignmentGroupOptions(String courseId) {
        if (StringUtils.isBlank((CharSequence)courseId)) {
            throw new IllegalArgumentException("Course ID can not be blank");
        }
        this.courseId = courseId;
    }

    public String getCourseId() {
        return this.courseId;
    }

    public ListAssignmentGroupOptions includes(List<Include> includes) {
        List<Include> assignmentDependents = Arrays.asList(Include.DISCUSSION_TOPIC, Include.ALL_DATES, Include.ASSIGNMENT_VISIBILITY, Include.SUBMISSION);
        if (includes.stream().anyMatch(assignmentDependents::contains) && !includes.contains((Object)Include.ASSIGNMENTS)) {
            throw new IllegalArgumentException("Including discussion topics, all dates, assignment visibility or submissions is only valid if you also include assignments");
        }
        this.addEnumList("include[]", includes);
        return this;
    }

    public ListAssignmentGroupOptions excludeAssignmentSubmissionTypes(List<ExcludeSubmissionTypes> toExclude) {
        this.addEnumList("exclude_assignment_submission_types[]", toExclude);
        return this;
    }

    public ListAssignmentGroupOptions overrideAssignmentDates(Boolean overrideDates) {
        this.addSingleItem("override_assignment_dates", overrideDates.toString());
        return this;
    }

    public ListAssignmentGroupOptions gradingPeriodId(Long periodId) {
        this.addSingleItem("grading_period_id", periodId.toString());
        return this;
    }

    public ListAssignmentGroupOptions scopeAssignmentsToStudent(Boolean scopeToStudent) {
        this.addSingleItem("scope_assignments_to_student", scopeToStudent.toString());
        return this;
    }

    public static enum ExcludeSubmissionTypes {
        ONLINE_QUIZ,
        DISCUSSION_TOPIC,
        WIKI_PAGE,
        EXTERNAL_TOOL;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum Include {
        ASSIGNMENTS,
        DISCUSSION_TOPIC,
        ALL_DATES,
        ASSIGNMENT_VISIBILITY,
        OVERRIDES,
        SUBMISSION;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

