/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.requestOptions;

import edu.ksu.canvas.requestOptions.BaseOptions;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.List;

public class ListCalendarEventsOptions
extends BaseOptions {
    public ListCalendarEventsOptions type(Type eventType) {
        this.addSingleItem("type", eventType.toString());
        return this;
    }

    public ListCalendarEventsOptions startDate(LocalDate startDate) {
        this.addSingleItem("start_date", DateTimeFormatter.ISO_LOCAL_DATE.format(startDate));
        return this;
    }

    public ListCalendarEventsOptions startDate(TemporalAccessor startDate) {
        this.addSingleItem("start_date", DateTimeFormatter.ISO_INSTANT.format(startDate));
        return this;
    }

    public ListCalendarEventsOptions endDate(LocalDate endDate) {
        this.addSingleItem("end_date", DateTimeFormatter.ISO_LOCAL_DATE.format(endDate));
        return this;
    }

    public ListCalendarEventsOptions endDate(TemporalAccessor endDate) {
        this.addSingleItem("end_date", DateTimeFormatter.ISO_INSTANT.format(endDate));
        return this;
    }

    public ListCalendarEventsOptions includeUndated(boolean include) {
        this.addSingleItem("undated", Boolean.toString(include));
        return this;
    }

    public ListCalendarEventsOptions includeAllEvents(boolean all) {
        this.addSingleItem("all_events", Boolean.toString(all));
        return this;
    }

    public ListCalendarEventsOptions contextCodes(List<String> contextCodes) {
        this.optionsMap.put("context_codes[]", contextCodes);
        return this;
    }

    public ListCalendarEventsOptions excludes(List<Exclude> excludes) {
        this.addEnumList("excludes[]", excludes);
        return this;
    }

    public static enum Exclude {
        DESCRIPTION,
        CHILD_EVENTS,
        ASSIGNMENT;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum Type {
        EVENT,
        ASSIGNMENT;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

