/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.requestOptions;

import edu.ksu.canvas.requestOptions.BaseOptions;
import java.util.List;

public class ListUserCoursesOptions
extends BaseOptions {
    private final String userId;

    public ListUserCoursesOptions(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public ListUserCoursesOptions includes(List<Include> includes) {
        this.addEnumList("include[]", includes);
        return this;
    }

    public ListUserCoursesOptions states(List<State> states) {
        this.addEnumList("state[]", states);
        return this;
    }

    public ListUserCoursesOptions enrollmentStates(EnrollmentState enrollmentState) {
        this.addSingleItem("enrollment_state", enrollmentState.toString());
        return this;
    }

    public static enum EnrollmentState {
        ACTIVE,
        INVITED_OR_PENDING,
        COMPLETED;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum State {
        UNPUBLISHED,
        AVAILABLE,
        COMPLETED,
        DELETED;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum Include {
        NEEDS_GRADING_COUNT,
        SYLLABUS_BODY,
        PUBLIC_DESCRIPTION,
        TOTAL_SCORES,
        CURRENT_GRADING_PERIOD_SCORES,
        TERM,
        COURSE_PROGRESS,
        SECTIONS,
        STORAGE_QUOTA_USED_MB,
        TOTAL_STUDENTS,
        PASSBACK_STATUS,
        FAVORITES,
        TEACHERS,
        OBSERVED_USERS,
        TABS,
        COURSE_IMAGE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

