/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpParameterBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(HttpParameterBuilder.class);

    public static String buildParameters(Map<String, List<String>> parameters) {
        return parameters.entrySet().stream().map(HttpParameterBuilder::buildParameter).reduce((a, b) -> a + b).filter(s -> s.length() > 0).map(s -> s.substring(1)).map(paramString -> "?" + paramString).orElse("");
    }

    private static String buildParameter(Map.Entry<String, List<String>> entry) {
        String paramName = entry.getKey();
        return entry.getValue().stream().reduce("", (a, paramValue) -> {
            String urlParams = "";
            try {
                urlParams = a + "&" + URLEncoder.encode(paramName, "UTF-8") + "=" + URLEncoder.encode(paramValue, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn("Failed to encode parameter " + paramName);
            }
            return urlParams;
        });
    }
}

