/*
 * Main.java
 *
 * Created on October 6, 2005, 1:39 PM
 */

package findstruct;
import java.io.IOException;
import java.util.*;
import java.util.regex.*;
import java.io.*;
import org.jdom.*;
import org.jdom.input.*;
import org.jdom.output.*;

/**
 *
 * @author Administrator
 */
public class Main {
    
    final static String defaultTemplateFileName = "default.xml";
    
    /** Creates a new instance of Main */
    public Main() {
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        // TODO code application logic here
        boolean test=false;
        if (test) {
            /*
        String wf = "Patient seen: 11:45 AM 21 year old male patient injured his right knee.  The injury  occurred when he was tackled while playing football 2 days ago.  He  complains of pain and swelling along the medial aspect of the right  patella, medial collateral ligament of the right knee and medial  collateral ligament of the right knee.  He has been able to bear  weight.  His symptoms are exacerbated by bending his knee..  He has  used a knee immobilizer.  With some relief. CURRENT MEDICATIONS: None. ALLERGIES: Denies known allergies. IMMUNIZATIONS: Up to date. "
                + "PE: Alert.  In no acute distress.  Well-developed.  Well-nourished.   Right Knee:  Positive for tenderness and swelling involving the  medial condyle of the distal right femur.  There is no effusion or  ecchymosis.  Full range of motion.  Slight limp.  Normal bulk, tone,  and strength.  Sensation intact.  The examination of the other knee  is unremarkable.  There is no evidence other trauma. "
                +"Other PE: No other injuries. "
                +"TREATMENT & COURSE:  Knee immobilizer applied. "
                +"DISPOSITION/PLAN: Discharged in good condition.   "
                +"ASSESSMENT: 1.  Sprain of the medial collateral ligament  844.1. "
                +"ATTENDING NOTE: Discussed with me agree with plan.";
             **/
            //String wf = "1.  Sprain of the medial collateral ligament  844.1. ";
            //String wf = "7 year old male was involved in a low speed multiple  vehicle motor vehicle accident 2 hours ago.";
            String wf = "1. Amyloidosis\n2. Congestive Heart Disease 65.\n3.\nDeath\n4. Life"; 
            if (wf==null) return;
            //String pat = "Patient seen:\\s*\\([0-9][0-9]\\|[0-9]\\):\\([0-9][0-9]\\)\\s*\\(AM\\|PM\\|\\)";
            //String pat = "Patient seen:\\s*(\\d{1,2}):(\\d{2})\\s*([AP]M)?";
            // "Patient seen:\\s*(\\d{1,2}):(\\d{2})\\s*([AP]M)?"
            //String pat = "Patient seen:\\s*(\\d{1,2})"; 
            final Pattern numPat = Pattern.compile("(\\s|^)(\\d+)([):\\.]\\s)",
                    Pattern.MULTILINE+Pattern.CASE_INSENSITIVE); 
            final Pattern listEndPat = Pattern.compile("$^$",Pattern.MULTILINE);
            //([ \\t\\n\\x0B\\f\\r^])
            System.out.println(listEndPat);
            //System.out.println("["+wf.substring(43)+"]");
            //Pattern p = Pattern.compile(pat, Pattern.CASE_INSENSITIVE);
            //System.out.println(p);
            Matcher m = numPat.matcher(wf);
            boolean gotOne = false;
            while (m.find()) {
                gotOne=true;
                System.out.println("Found pattern at "+m.start()+"-"+m.end()+":"+m.group());
                for (int i=0; i<= m.groupCount(); i++) {
                    System.out.println(" "+ i+":["+m.group(i)+"]");
                }
            } 
            if (!gotOne) System.out.println("No match.");
        } else {
            
            boolean showInstructions = false;
            String templateFileName = null;
            StructModel template = null;
            ArrayList<String> fileNames = new ArrayList<String>();
            String outputExtension = "xml";
            if (args.length==0) {
                showInstructions = true;
            } else {
                boolean pastOpts = false;
                for (int i=0 ; i<args.length; i++)  {
                    String a = args[i];
                    if (!pastOpts && a.startsWith("-")) {
                        String option = a.substring(1);
                        if (++i > args.length) {
                            System.err.println("No value given for option -" + option);
                            showInstructions = true;
                        } else if (option.equals("t")) {
                            templateFileName = args[i];
                        } else if (option.equals("x")) {
                            outputExtension = args[i];
                            if (outputExtension.startsWith(".")) {
                                outputExtension = outputExtension.substring(1);
                            }
                        } else {
                            System.err.println("Invalid option: "+option);
                            showInstructions = true;
                        }
                    } else {
                        pastOpts = true;
                        fileNames.add(a);
                    }
                }
                System.out.println("Files to process:");
                for (String fn: fileNames) {
                    System.out.println(fn);
                }
                System.out.println("Template: " + templateFileName);
            }
            if (showInstructions) {
                System.out.println("Usage: findstruct [-t template] [-x output_extension] file1 file2 ...");
            } else {
                if (templateFileName==null) {
                    templateFileName = defaultTemplateFileName;
                }
                SAXBuilder parser = new SAXBuilder();
                try {
                    template = new StructModel(parser.build(new File(templateFileName)));
                } catch (IOException e) {
                    System.err.println("Could not find/read template file "
                            + templateFileName + ": " + e);
                } catch (JDOMException e) {
                    System.err.println("Error parsing template file "
                            + templateFileName + ": " + e);
                }
                if (template!=null) {
                    for (String fn: fileNames) {
                        File inFile = new File(fn);
                        String wholeFile = readFile(inFile);
                        if (wholeFile==null) {
                            System.err.println("File "+inFile+" not processed.");
                        } else {
                            Document res = new Document();
                            Element e = template.process(wholeFile);
                            res.addContent(e);
                            XMLOutputter outp = new XMLOutputter(Format.getPrettyFormat());
                            String outFn = fileNameWithSuffix(fn, outputExtension);
                            File outFile = new File(outFn);
                            try {
                                BufferedWriter out = new BufferedWriter(new FileWriter(outFile));
                                outp.output(res, out);
                            } catch (IOException ex) {
                                System.err.println("IOException in writing "+outFn+": "+ex);
                            }
                            System.out.println("Processed file "+inFile+" to "+outFile);
                        }
                    }
                }
            }}
    }
    
    static String readFile(File f) {
        try {
            BufferedReader r = new BufferedReader(new FileReader(f));
            StringBuffer sb = new StringBuffer();
            String ln;
            while ((ln = r.readLine())!=null) {
                sb.append(ln); sb.append("\n");
            }
            return sb.toString();
        } catch (FileNotFoundException e) {
            System.err.println("File "+f+" not found.");
        } catch (IOException e) {
            System.err.println("IO Error in "+f+":"+e);
        }
        return null;
    }
    
    static final char SUFFIX_SEPARATOR = '.';
    
    static String fileNameWithSuffix(String fn, String suffix) {
        int where = fn.lastIndexOf(SUFFIX_SEPARATOR);
        String v = fn;
        if (where>0) v = v.substring(0, where);
        return v + SUFFIX_SEPARATOR + suffix;
    }
    
}
