/********************************************************************************
 * MIT Java Wordnet Interface (JWI)
 * Copyright (c) 2007-2011 Massachusetts Institute of Technology
 *
 * This is the non-commercial version of JWI.  This version may *not* be used
 * for commercial purposes.
 * 
 * This program and the accompanying materials are made available by MIT under 
 * the terms of the MIT JWI Non-Commercial License license. Contact 
 * markaf@alum.mit.edu for further details, or to inquire about obtaining a 
 * commercial license.
 *******************************************************************************/

package edu.mit.jwi.item;

/**
 * An object that potentially has an associated version.
 * 
 * @author Mark A. Finlayson
 * @version 2.2.1
 * @since JWI 2.1.0
 */
public interface IHasVersion {

	/**
	 * Returns the associated version for this object. If this object is not
	 * associated with any particular version, this method may return
	 * <code>null</code>.
	 * 
	 * @return The associated version, or <code>null</code> if none.
	 * @since JWI 2.1.0
	 */
	public IVersion getVersion();

}
