/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.morph;

import edu.mit.jwi.IDictionary;
import edu.mit.jwi.item.IExceptionEntry;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.morph.SimpleStemmer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;

public class WordnetStemmer
extends SimpleStemmer {
    private final IDictionary dict;

    public WordnetStemmer(IDictionary dict) {
        if (dict == null) {
            throw new NullPointerException();
        }
        this.dict = dict;
    }

    public IDictionary getDictionary() {
        return this.dict;
    }

    @Override
    public List<String> findStems(String word, POS pos) {
        word = this.normalize(word);
        if (pos == null) {
            return super.findStems(word, null);
        }
        TreeSet<String> result = new TreeSet<String>();
        IExceptionEntry entry = this.dict.getExceptionEntry(word, pos);
        boolean isException = false;
        if (entry != null) {
            isException = true;
            result.addAll(entry.getRootForms());
        }
        if (this.dict.getIndexWord(word, pos) != null) {
            result.add(word);
        }
        if (isException) {
            return new ArrayList<String>(result);
        }
        List<String> possibles = super.findStems(word, pos);
        for (String possible : possibles) {
            if (this.dict.getIndexWord(possible, pos) == null) continue;
            if (result == null) {
                result = new TreeSet();
            }
            result.add(possible);
        }
        if (result.isEmpty()) {
            if (possibles.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList<String>(possibles);
        }
        return new ArrayList<String>(result);
    }
}

