/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.siso;

import edu.nps.moves.siso.jaxb.BitmaskT;
import edu.nps.moves.siso.jaxb.BitmaskrowT;
import edu.nps.moves.siso.jaxb.Ebv;
import edu.nps.moves.siso.jaxb.EnumT;
import edu.nps.moves.siso.jaxb.EnumrowT;
import edu.nps.moves.siso.jaxb.GenerictableT;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.nio.channels.FileChannel;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

public class EBVReader {
    public static final String EBV_XML_DOCUMENT = "data/siso-std-010.xml";

    public static void main(String[] args) {
        try {
            JAXBContext context = JAXBContext.newInstance((String)"edu.nps.moves.siso.jaxb");
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Ebv data = (Ebv)unmarshaller.unmarshal((InputStream)new FileInputStream(EBV_XML_DOCUMENT));
            EBVReader.writeCppEnumerationCommon();
            List<GenerictableT> genericList = data.getEnumOrBitmaskOrCet();
            for (int idx = 0; idx < genericList.size(); ++idx) {
                GenerictableT en;
                GenerictableT gen = genericList.get(idx);
                if (gen instanceof EnumT) {
                    EBVReader reader;
                    en = (EnumT)gen;
                    List<EnumrowT> rows = ((EnumT)en).getEnumrow();
                    if (gen.getCname().equalsIgnoreCase("pduheader.pdutype")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("PduType", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.type.country")) {
                        reader = new EBVReader();
                        reader.writeCountryEnumeration("CountryType", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("pduheader.protocolfamily")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("ProtocolFamily", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.forceid")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("ForceID", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.type.kind")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("EntityKind", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.type.kind.1.domain.1.cat")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("PlatformLand", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.type.kind.1.domain.2.cat")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("PlatformAir", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.type.kind.1.domain.3.cat")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("PlatformSurface", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.type.kind.1.domain.4.cat")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("PlatformSubSurface", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.type.kind.1.domain.5.cat")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("PlatformSpace", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.type.kind.2.domain")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("MunitionDomain", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.type.kind.2.cat")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("MunitionCategory", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.type.225.kind.3.subcat")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("USWeaponsForLifeForms", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.type.222.kind.3.subcat")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("CISWeaponsForLifeForms", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.type.224.kind.3.subcat")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("UKWeaponsForLifeForms", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.type.71.kind.3.subcat")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("FrenchWeaponsForLifeForms", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.type.78.kind.3.subcat")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("GermanWeaponsForLifeForms", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("pduheader.protocolversion")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("ProtocolVersion", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.type.kind.1.domain")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("EntityDomain", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.type.kind.4.subcat")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("EnvironmentalKind", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.type.kind.7.cat")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("RadioCategory", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.type.kind.7.version")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("RadioNomenclatureVersion", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.type.kind.7.nomenclature")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("RadioNomenclature", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.type.kind.8.domain.2.cat")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("ExpendableAirCategory", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.type.kind.8.domain.3.cat")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("ExpendableSurfaceCategory", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.type.kind.8.domain.4.cat")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("ExpendableSubsurfaceCategory", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.type.kind.9.cat")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("SensorEmitterCategory", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.dra")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("DeadReckoningAlgorithm", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.markingtext")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("EntityMarking", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.markingtext.cctt.div")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("DivisionCorpsDesignation", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.markingtext.cctt.1cavunit")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("FirstCavHighLevelUnit", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.markingtext.cctt.1infunit")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("FirstInfHighLevelUnit", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.markingtext.cctt.company")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("CompanyBatteryTroop", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.markingtext.cctt.platoon")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("PlatoonSection", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.markingtext.cctt.vehicle")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Vehicle", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.markingtext.cctt.symbol1")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Bytes8_9_10_12", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.markingtext.cctt.symbol2")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Byte11", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.markingtext.chevron.symbol")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("DigitChevronCode", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.vp.type")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("ParameterTypeDesignator", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.vp.type.1.attached")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("AttachedParts", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.vp.type.0.articulated.offset")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("ArticulatedPartsOffsetNumber", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("es.vp.type.0.articulated.index")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("ArticulatedPartsIndexNumber", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("warfare.burstdescriptor.warhead")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Warhead", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("warfare.burstdescriptor.fuse")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Fuse", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("warfare.detonationresult")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("DetonationResult", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("log.servicerequest")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("ServiceRequestPDU", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("log.repaircomplete.general")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("GeneralRepairCode", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("log.repaircomplete.drivetrain")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("DriveTrain", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("log.repaircomplete.hull")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("HullAirframeBody", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("log.repaircomplete.environment")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("InterfacesWithEnvironment", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("log.repaircomplete.weapons")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Weapons", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("log.repaircomplete.fuelsystem")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("FuelSystems", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("log.repaircomplete.electronics")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Electronics", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("log.repaircomplete.lifesupport")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("LifeSupportSystems", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("log.repaircomplete.hydraulic")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("HydraulicSystemsAndActuators", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("log.repaircomplete.auxilary")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("AuxiliaryCraft", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("log.repairresponse")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("RepairResponsePDU", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("simman.datumid")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("DatumSpecificationRecord", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("simman.stop.reason")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Reason", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("simman.ack.ackflag")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("AcknowledgeFlag", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("simman.ack.responseflag")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("ResponseFlag", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("simman.actionrequest.actionid")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("ActionID", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("simman.actionresponse.status")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("RequestStatus", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("simman.eventreport.eventtype")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("EventType", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("simman.reliability.service")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("RequiredReliabilityService", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.emission.name.electro")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("ElectromagneticEmitters", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.emission.name.acoustic")) {
                        reader = new EBVReader();
                        System.out.println("Enumeration row list length = " + ((EnumT)en).getEnumrow().size());
                        reader.writeStandardEnumeration("AcousticEmitters", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.emission.name.other")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("OtherAcousticEmitters", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.emission.function")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Function", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.emission.stateupdate")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("StateUpdateIndicator", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.emission.beamfunction")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("BeamFunction", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.emission.hdtj")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("HighDensityTrackJam", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.designator.codename")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("CodeName", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.designator.code")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("DesignatorCode", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.iff.type")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("SystemType", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.iff.name")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("SystemName", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.iff.mode")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("SystemMode", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.iff.layerspecific")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("LayerSpecificInformation", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.iff.type.1.fop.altp4")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Type1AltParameter4", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.iff.type.1.sop.param1")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Type1OperationalParameter1", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.iff.type.1.sop.param2")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Type1OperationalParameter2", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.iff.type.2.fop.altp4")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Type2AltParameter4", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.iff.type.2.sop.param1")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Type2OperationalParameter1", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.iff.type.2.sop.param2")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Type2OperationalParameter2", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.iff.type.3.fop.altp4")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Type3AltParameter4", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.iff.type.3.sop.param1")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Type3OperationalParameter1", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.iff.type.3.sop.param2")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Type3OperationalParameter2", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.iff.type.4.fop.altp4")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Type4AltParameter4", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.iff.type.4.sop.param1")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Type4OperationalParameter1", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.iff.type.4.sop.param2")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Type4OperationalParameter2", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.iff.type.5.fop.altp4")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Type5AltParameter4", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.iff.type.5.sop.param1")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Type5OperationalParameter1", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.iff.type.5.sop.param2")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Type5OperationalParameter2", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.ua.statechangeupdate")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("StateChangeUpdateIndicator", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.ua.systemname")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("AcousticSystemName", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.ua.function")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Function", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.ua.activeparameterindex")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("ActiveEmissionParameterIndex", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.ua.scanpattern")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("ScanPattern", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.ua.passiveparameterindex")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("PassiveParameterIndex", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.ua.apaparameterindex")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("AdditionalPassiveActivity", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.sees.power.aircraft")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Aircraft", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.sees.power.helicopters")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Helicopters", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("der.sees.power.tanks")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Tanks", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.tx.mod.major")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("MajorModulation", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.tx.mod.major.1.detail")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("DetailedModAmpMod", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.tx.mod.major.2.detail")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("DetailedModAmpAndAngle", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.tx.mod.major.3.detail")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("DetailedModAngleMod", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.tx.mod.major.4.detail")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("DetailedModCombinationMod", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.tx.mod.major.5.detail")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("DetailedModPulseMod", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.tx.mod.major.6.detail")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("DetailedModUnmodulatedMod", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.tx.mod.major.7.detail")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("DetailedModCarrierPhaseShift", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.tx.mod.system")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("RadioSystem", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.tx.state")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("TransmitState", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.tx.inputsource")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("InputSource", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.tx.cryptosystem")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("CryptoSystem", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.tx.antennapatterntype")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("AntennaPatternType", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.tx.referencesystem")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("ReferenceSystem", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.tx.param.cctt.start")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("MessageStart", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.tx.param.cctt.clear")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("ClearChannel", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.tx.param.jtids.mode1")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("XmitTermPriMode", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.tx.param.jtids.mode2")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("XmitTermSecMode", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.tx.param.jtids.sync")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("SynchronizationState", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.tx.protocolid")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("UserProtocolIDNum", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.tx.tdltype")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("TDLType", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.rx.state")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("ReceiverState", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.ic.controltype")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("ControlType", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.ic.commtype")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("CommunicationType", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.ic.command")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Command", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.ic.transmitstate")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("XmitLineState", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.ic.deststate")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("DestLineState", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("radio.ic.param.type")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("RecordType", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("entity.collision.type")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("CollisionType", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("entity.mine.sensortype")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("SensorTypes", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("entity.mine.sensortype.1.subcat")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Optical", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("entity.mine.sensortype.2.subcat")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("FLIR", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("entity.mine.sensortype.3.subcat")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("RADAR", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("entity.mine.sensortype.4.subcat")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Magnetic", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("entity.mine.sensortype.5.subcat")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Laser", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("entity.mine.sensortype.6.subcat")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("SONAR", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("entity.mine.sensortype.7.subcat")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Physical", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("entity.mine.sensortype.8.subcat")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Multispectral", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("eman.aggregate.state")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("AggregateState", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("eman.aggregate.formation")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Formation", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("eman.aggregate.type.kind")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("AggregateKind", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("eman.aggregate.type.subcategory")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Subcategory", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("eman.aggregate.type.specific")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Specific", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("eman.ispartof.nature")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Nature", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("eman.ispartof.position")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("Position", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("eman.ispartof.stationname")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("StationName", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("eman.isgroupof.category")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("GroupedEntityCategory", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("eman.isgroupof.reststatus")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("RestStatus", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("eman.tc.transfertype")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("TransferType", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("env.obj.objecttype.kind")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("ObjectKind", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("env.gridded.fieldnumber")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("FieldNumber", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("env.gridded.coordinatesystem")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("CoordinateSystem", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("env.gridded.constantgrid")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("ConstantGrid", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("env.gridded.sampletype")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("SampleType", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("env.gridded.datarepresentation")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("DataRepresentation", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("env.process.modeltype")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("ModelType", (EnumT)en);
                    }
                    if (gen.getCname().equalsIgnoreCase("env.process.type.geometryrecord")) {
                        reader = new EBVReader();
                        reader.writeStandardEnumeration("GeometryRecordTypeField", (EnumT)en);
                    }
                    if (!gen.getCname().equalsIgnoreCase("env.process.type.staterecord")) continue;
                    reader = new EBVReader();
                    reader.writeStandardEnumeration("StateRecordTypeField", (EnumT)en);
                    continue;
                }
                if (!(gen instanceof BitmaskT)) continue;
                en = (BitmaskT)gen;
                EBVReader reader = new EBVReader();
                reader.writeBitmask(gen.getCname(), (BitmaskT)en);
            }
        }
        catch (Exception e) {
            System.out.println("oops, problem creating files");
        }
    }

    private static String titleCase(String str) {
        BreakIterator wordBreaker = BreakIterator.getWordInstance();
        wordBreaker.setText(str);
        int end = 0;
        System.out.println("full str: " + str);
        int start = wordBreaker.first();
        while ((end = wordBreaker.next()) != -1) {
            String word = str.substring(start, end);
            System.out.println("word: [" + word + "]");
            start = end;
        }
        return str;
    }

    private static String readFileAsString(String filePath) throws IOException {
        StringBuilder fileData = new StringBuilder(2000);
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            fileData.append(buf, 0, numRead);
        }
        reader.close();
        return fileData.toString();
    }

    private static void copyFile(String srcFilename, String dstFilename) {
        try {
            FileChannel srcChannel = new FileInputStream(srcFilename).getChannel();
            FileChannel dstChannel = new FileOutputStream(dstFilename).getChannel();
            dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
            srcChannel.close();
            dstChannel.close();
        }
        catch (IOException e) {
            System.out.println("Error copying file " + srcFilename + " to " + dstFilename + ": " + e);
        }
    }

    private static void writeCppEnumerationCommon() {
        try {
            String enumerationFile = "Enumeration.h";
            System.out.println("Writing common enumeration header" + enumerationFile);
            EBVReader.copyFile("templates/" + enumerationFile, "src/main/cpp/disenum/" + enumerationFile);
            enumerationFile = "enumcfg.h";
            System.out.println("Writing common enumeration header" + enumerationFile);
            EBVReader.copyFile("templates/" + enumerationFile, "src/main/cpp/disenum/" + enumerationFile);
        }
        catch (Exception e) {
            System.out.println("writeEnumerationCommon exception:" + e);
        }
    }

    private void writeCppEnumeration(String enumerationName, EnumT anEnumeration, boolean isCountry) {
        try {
            String enumName;
            int idx;
            ArrayList<String> enumNamesUsed = new ArrayList<String>();
            HashMap<String, Integer> enumValues = new HashMap<String, Integer>();
            HashMap<String, String> enumDescriptions = new HashMap<String, String>();
            HashMap<String, String> enumInternetCodes = new HashMap<String, String>();
            Properties internetCountries = new Properties();
            FileInputStream fis = new FileInputStream(new File("data/countryCodes.properties"));
            if (isCountry) {
                internetCountries.load(fis);
            }
            int maxValue = 0;
            int usedCount = 1;
            List<EnumrowT> l = anEnumeration.getEnumrow();
            for (int idx2 = 0; idx2 < l.size(); ++idx2) {
                EnumrowT er = l.get(idx2);
                String description = er.getDescription();
                if (description == null || description.equals("")) {
                    description = "Missing Description";
                }
                String enumName2 = this.enumifyString(description, true);
                int enumValue = er.getId();
                if (enumNamesUsed.contains(enumName2)) {
                    enumName2 = enumName2 + "_" + usedCount;
                    ++usedCount;
                }
                enumNamesUsed.add(enumName2);
                enumValues.put(enumName2, enumValue);
                description = description.replace("\"", "");
                enumDescriptions.put(enumName2, description);
                String internetDomainCode = "Unknown";
                if (isCountry) {
                    Set<Map.Entry<Object, Object>> entrySet = internetCountries.entrySet();
                    for (Map.Entry<Object, Object> anEntry : entrySet) {
                        if (!((String)anEntry.getValue()).equalsIgnoreCase(description)) continue;
                        internetDomainCode = (String)anEntry.getKey();
                        break;
                    }
                    enumInternetCodes.put(enumName2, internetDomainCode);
                }
                if (maxValue >= enumValue) continue;
                maxValue = enumValue;
            }
            ++maxValue;
            File outputFile = new File("src/main/cpp/disenum/" + enumerationName + ".h");
            outputFile.createNewFile();
            System.out.println("Writing enumeration " + outputFile.getPath());
            PrintWriter pw = new PrintWriter(outputFile);
            String template = new String();
            StringBuilder allEnums = new StringBuilder();
            Iterator enumsIter = enumNamesUsed.iterator();
            template = isCountry ? EBVReader.readFileAsString("templates/countryEnumTemplate.h") : EBVReader.readFileAsString("templates/enumTemplate.h");
            for (idx = 0; idx < enumNamesUsed.size(); ++idx) {
                enumName = (String)enumsIter.next();
                allEnums.append("static " + enumerationName + " " + enumName + ";\n    ");
            }
            template = template.replaceAll("@ENUMERATIONNAME", enumerationName);
            template = template.replaceAll("@ENUMUPPERCASE", enumerationName.toUpperCase());
            template = template.replaceAll("@ENUMS", allEnums.toString());
            pw.print(template);
            pw.flush();
            pw.close();
            outputFile = new File("src/main/cpp/disenum/" + enumerationName + ".cpp");
            outputFile.createNewFile();
            System.out.println("Writing enumeration " + outputFile.getPath());
            pw = new PrintWriter(outputFile);
            template = new String();
            allEnums = new StringBuilder();
            enumsIter = enumNamesUsed.iterator();
            if (isCountry) {
                template = EBVReader.readFileAsString("templates/countryEnumTemplate.cpp");
                for (idx = 0; idx < enumNamesUsed.size(); ++idx) {
                    enumName = (String)enumsIter.next();
                    String enumInternetCode = (String)enumInternetCodes.get(enumName);
                    int enumValue = (Integer)enumValues.get(enumName);
                    String enumDescription = (String)enumDescriptions.get(enumName);
                    allEnums.append(enumerationName + " " + enumerationName + "::" + enumName + "(" + enumValue + ", " + "\"" + enumDescription + "\",\"" + enumInternetCode + "\");\n");
                }
            } else {
                template = EBVReader.readFileAsString("templates/enumTemplate.cpp");
                for (idx = 0; idx < enumNamesUsed.size(); ++idx) {
                    enumName = (String)enumsIter.next();
                    int enumValue = (Integer)enumValues.get(enumName);
                    String enumDescription = (String)enumDescriptions.get(enumName);
                    allEnums.append(enumerationName + " " + enumerationName + "::" + enumName + "(" + enumValue + ", " + "\"" + enumDescription + "\");\n");
                }
            }
            template = template.replaceAll("@ENUMERATIONNAME", enumerationName);
            template = template.replaceAll("@MAXVALUE", Integer.toString(maxValue));
            template = template.replaceAll("@ENUMSINIT", allEnums.toString());
            pw.print(template);
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            System.out.println("writeStandard exception:" + e);
        }
    }

    private void writeJavaStandardEnumeration(String enumerationName, EnumT anEnumeration) {
        String enumerationFile = "src/main/java/edu/nps/moves/disenum/" + enumerationName + ".java";
        System.out.println("Writing standard enumeration " + enumerationFile);
        try {
            File outputFile = new File(enumerationFile);
            outputFile.createNewFile();
            PrintWriter pw = new PrintWriter(outputFile);
            int maxValue = 0;
            pw.println("package edu.nps.moves.disenum;");
            pw.println();
            pw.println("import java.util.HashMap;");
            pw.println("import edu.nps.moves.siso.EnumNotFoundException;");
            pw.println();
            pw.println("/** Enumeration values for " + enumerationName);
            pw.println(" * The enumeration values are generated from the SISO DIS XML EBV document (R35), which was");
            pw.println(" * obtained from http://discussions.sisostds.org/default.asp?action=10&fd=31<p>");
            pw.println(" *");
            pw.println(" * Note that this has two ways to look up an enumerated instance from a value: a fast");
            pw.println(" * but brittle array lookup, and a slower and more garbage-intensive, but safer, method.");
            pw.println(" * if you want to minimize memory use, get rid of one or the other.<p>");
            pw.println(" *");
            pw.println(" * Copyright 2008-2009. This work is licensed under the BSD license, available at");
            pw.println(" * http://www.movesinstitute.org/licenses<p>");
            pw.println(" *");
            pw.println(" * @author DMcG, Jason Nelson");
            pw.println(" */");
            pw.println();
            pw.flush();
            pw.println("public enum " + enumerationName + " \n{\n");
            BigInteger val = anEnumeration.getId();
            boolean ofInterest = false;
            if (val.intValue() == 83) {
                ofInterest = true;
            }
            HashSet<String> enumNamesUsed = new HashSet<String>();
            int usedCount = 1;
            List<EnumrowT> l = anEnumeration.getEnumrow();
            for (int idx = 0; idx < l.size(); ++idx) {
                EnumrowT er = l.get(idx);
                String description = er.getDescription();
                if (description == null || description.equals("")) {
                    description = "Missing Description";
                }
                String enumName = this.enumifyString(description, true);
                int enumValue = er.getId();
                if (enumNamesUsed.contains(enumName)) {
                    enumName = enumName + "_" + usedCount;
                    ++usedCount;
                }
                enumNamesUsed.add(enumName);
                description = description.replace("\"", "");
                if (maxValue < enumValue) {
                    maxValue = enumValue;
                }
                pw.print("    " + enumName + "(" + enumValue + ", " + "\"" + description + "\")");
                if (idx != l.size() - 1) {
                    pw.print(",");
                } else {
                    pw.print(";");
                }
                pw.println();
            }
            pw.println();
            pw.flush();
            pw.println("    /** The enumerated value */");
            pw.println("    public final int value;");
            pw.println("");
            pw.println("    /** Text/english description of the enumerated value */");
            pw.println("    public final String description;");
            pw.println();
            pw.println("/** This is an array, with each slot corresponding to an enumerated value. This is a fast but brittle way to look up");
            pw.println(" * enumerated values. If there is no enumeration corresponding to the value it will fail, and it will also fail if the");
            pw.println(" * index it out of range of the array. But it is fast, and generates less garbage than the alternative of using ");
            pw.println(" * getEnumerationForValue(). It should be used only in real-time environments, and be careful even then.<p>");
            pw.println(" * Use as " + enumerationName + ".lookup[aVal] to get the enumeration that corresponds to a value.<p>");
            pw.println(" * In non-realtime environments, the prefered method is getEnumerationForValue().");
            pw.println(" */");
            pw.println("static public " + enumerationName + " lookup[] = new " + enumerationName + "[" + ++maxValue + "];");
            pw.println();
            pw.println("static private HashMap<Integer, " + enumerationName + ">enumerations = new HashMap<Integer, " + enumerationName + ">();");
            pw.println();
            pw.println("/* initialize the array and hash table at class load time */");
            pw.println("static \n{");
            pw.println("    for(" + enumerationName + " anEnum:" + enumerationName + ".values())");
            pw.println("    {");
            pw.println("        lookup[anEnum.value] = anEnum;");
            pw.println("        enumerations.put(new Integer(anEnum.getValue()), anEnum);");
            pw.println("    }");
            pw.println("}\n");
            pw.println("/** Constructor */");
            pw.println(enumerationName + "(int value, String description)");
            pw.println("{");
            pw.println("    this.value = value;");
            pw.println("    this.description = description;");
            pw.println("}");
            pw.println();
            pw.println("/** Returns the string description associated with the enumerated instance with this value. ");
            pw.println(" * If there is no enumerated instance for this value, the string Invalid enumeration: <val> is returned.");
            pw.println("*/");
            pw.println("static public String getDescriptionForValue(int aVal)");
            pw.println("{");
            pw.println("  String desc;");
            pw.println();
            pw.println("    " + enumerationName + " val = enumerations.get(new Integer(aVal));");
            pw.println("      if(val == null)");
            pw.println("        desc = \"Invalid enumeration: \" + (new Integer(aVal)).toString();");
            pw.println("      else");
            pw.println("         desc = val.getDescription();");
            pw.println();
            pw.println("      return desc;");
            pw.println("}");
            pw.println();
            pw.println("/** Returns the enumerated instance with this value. ");
            pw.println(" * If there is no enumerated instance for this value, the exception is thrown.");
            pw.println("*/");
            pw.println("static public " + enumerationName + " getEnumerationForValue(int aVal) throws EnumNotFoundException");
            pw.println("{");
            pw.println("    " + enumerationName + " val;");
            pw.println("      val = enumerations.get(new Integer(aVal));");
            pw.println("      if(val == null)");
            pw.println("         throw new EnumNotFoundException(\"no enumeration found for value \" + aVal + \" of enumeration " + enumerationName + "\");");
            pw.println("      return val;");
            pw.println("}");
            pw.println();
            pw.println("/** Returns true if there is an enumerated instance for this value, false otherwise. ");
            pw.println("*/");
            pw.println("static public boolean enumerationForValueExists(int aVal)");
            pw.println("{");
            pw.println("    " + enumerationName + " val;");
            pw.println("      val = enumerations.get(new Integer(aVal));");
            pw.println("      if(val == null)");
            pw.println("         return false;");
            pw.println("      return true;");
            pw.println("}");
            pw.println();
            pw.println("/** Returns the enumerated value for this enumeration */");
            pw.println("public int getValue()");
            pw.println("{");
            pw.println("  return value;");
            pw.println("}");
            pw.println();
            pw.println();
            pw.println("/** Returns a text descriptioni for this enumerated value. This is usually used as the basis for the enumeration name. */");
            pw.println("public String getDescription()");
            pw.println("{");
            pw.println("  return description;");
            pw.println("}");
            pw.println();
            pw.println("}");
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            System.out.println("writeStandard exception:" + e);
        }
    }

    private void writeStandardEnumeration(String enumerationName, EnumT anEnumeration) {
        this.writeJavaStandardEnumeration(enumerationName, anEnumeration);
        this.writeCppEnumeration(enumerationName, anEnumeration, false);
    }

    private void writeCountryEnumeration(String enumerationName, EnumT anEnumeration) {
        this.writeJavaCountryEnumeration(enumerationName, anEnumeration);
        this.writeCppEnumeration(enumerationName, anEnumeration, true);
    }

    private void writeJavaCountryEnumeration(String enumerationName, EnumT anEnumeration) {
        try {
            String enumerationFile = "src/main/java/edu/nps/moves/disenum/" + enumerationName + ".java";
            File outputFile = new File(enumerationFile);
            outputFile.createNewFile();
            PrintWriter pw = new PrintWriter(outputFile);
            int maxValue = 0;
            Properties internetCountries = new Properties();
            FileInputStream fis = new FileInputStream(new File("data/countryCodes.properties"));
            internetCountries.load(fis);
            pw.println("package edu.nps.moves.disenum;");
            pw.println();
            pw.println("import java.util.HashMap;");
            pw.println("import edu.nps.moves.siso.EnumNotFoundException;");
            pw.println();
            pw.println("/** Enumeration values for " + enumerationName);
            pw.println(" * The enumeration values are generated from the SISO DIS XML EBV document (R35), which was");
            pw.println(" * obtained from http://discussions.sisostds.org/default.asp?action=10&fd=31<p>");
            pw.println(" *");
            pw.println(" * Note that this has two ways to look up an enumerated instance from a value: a fast");
            pw.println(" * but brittle array lookup, and a slower and more garbage-intensive, but safer, method.");
            pw.println(" * if you want to minimize memory use, get rid of one or the other.<p>");
            pw.println(" *");
            pw.println(" * Copyright 2008-2009. This work is licensed under the BSD license, available at");
            pw.println(" * http://www.movesinstitute.org/licenses<p>");
            pw.println(" *");
            pw.println(" * @author DMcG, Jason Nelson");
            pw.println(" */");
            pw.println();
            pw.println("public enum " + enumerationName + " \n{\n");
            List<EnumrowT> l = anEnumeration.getEnumrow();
            for (int idx = 0; idx < l.size(); ++idx) {
                EnumrowT er = l.get(idx);
                String description = er.getDescription();
                String enumName = this.enumifyString(description, true);
                int enumValue = er.getId();
                String internetDomainCode = "Unknown";
                Set<Map.Entry<Object, Object>> entrySet = internetCountries.entrySet();
                for (Map.Entry<Object, Object> anEntry : entrySet) {
                    if (!((String)anEntry.getValue()).equalsIgnoreCase(description)) continue;
                    internetDomainCode = (String)anEntry.getKey();
                    break;
                }
                if (maxValue < enumValue) {
                    maxValue = enumValue;
                }
                pw.print("    " + enumName + "(" + enumValue + ", " + "\"" + description + "\"" + ", " + "\"" + internetDomainCode + "\")");
                if (idx != l.size() - 1) {
                    pw.print(",");
                } else {
                    pw.print(";");
                }
                pw.println();
            }
            pw.println();
            pw.println("    /** The enumerated value */");
            pw.println("    public final int value;");
            pw.println("");
            pw.println("    /** Text/english description of the enumerated value */");
            pw.println("    public final String description;");
            pw.println();
            pw.println("    /** Internet domain code (US, FR, UK, CA, etc). This is a guess for many countries */");
            pw.println("    public final String internetDomainCode;");
            pw.println();
            pw.println("/** This is an array, with each slot corresponding to an enumerated value");
            pw.println(" * and that slot containing the enumerated object. Use to look up enumerated object when you have the value");
            pw.println(" */");
            pw.println("static public " + enumerationName + " lookup[] = new " + enumerationName + "[" + ++maxValue + "];");
            pw.println("static private HashMap<Integer, " + enumerationName + ">enumerations = new HashMap<Integer, " + enumerationName + ">();");
            pw.println();
            pw.println("/* initialize the array and hash table at class load time */");
            pw.println("static \n{");
            pw.println("    for(" + enumerationName + " anEnum:" + enumerationName + ".values())");
            pw.println("    {");
            pw.println("        lookup[anEnum.value] = anEnum;");
            pw.println("        enumerations.put(new Integer(anEnum.getValue()), anEnum);");
            pw.println("    }");
            pw.println("}\n");
            pw.println("/** Constructor */");
            pw.println(enumerationName + "(int value, String description, String internetDomainCode)");
            pw.println("{");
            pw.println("    this.value = value;");
            pw.println("    this.description = description;");
            pw.println("    this.internetDomainCode = internetDomainCode;");
            pw.println("}");
            pw.println();
            pw.println("/** Returns the string description associated with the enumerated instance with this value. ");
            pw.println(" * If there is no enumerated instance for this value, the string Invalid enumeration: <val> is returned.");
            pw.println("*/");
            pw.println("static public String getDescriptionForValue(int aVal)");
            pw.println("{");
            pw.println("  String desc;");
            pw.println();
            pw.println("    " + enumerationName + " val = enumerations.get(new Integer(aVal));");
            pw.println("      if(val == null)");
            pw.println("        desc = \"Invalid enumeration: \" + (new Integer(aVal)).toString();");
            pw.println("      else");
            pw.println("         desc = val.getDescription();");
            pw.println();
            pw.println("      return desc;");
            pw.println("}");
            pw.println();
            pw.println("/** Returns the enumerated instance with this value. ");
            pw.println(" * If there is no enumerated instance for this value, the exception is thrown.");
            pw.println("*/");
            pw.println("static public " + enumerationName + " getEnumerationForValue(int aVal) throws EnumNotFoundException");
            pw.println("{");
            pw.println("    " + enumerationName + " val;");
            pw.println("      val = enumerations.get(new Integer(aVal));");
            pw.println("      if(val == null)");
            pw.println("         throw new EnumNotFoundException(\"no enumeration found for value \" + aVal + \" of enumeration " + enumerationName + "\");");
            pw.println("      return val;");
            pw.println("}");
            pw.println();
            pw.println("/** Returns true if there is an enumerated instance for this value, false otherwise. ");
            pw.println("*/");
            pw.println("static public boolean enumerationForValueExists(int aVal)");
            pw.println("{");
            pw.println("    " + enumerationName + " val;");
            pw.println("      val = enumerations.get(new Integer(aVal));");
            pw.println("      if(val == null)");
            pw.println("         return false;");
            pw.println("      return true;");
            pw.println("}");
            pw.println();
            pw.println("/** Returns the enumerated value for this enumeration */");
            pw.println("public int getValue()");
            pw.println("{");
            pw.println("  return value;");
            pw.println("}");
            pw.println();
            pw.println("/** Returns the string description for this enumeration. */");
            pw.println("public String getDescription()");
            pw.println("{");
            pw.println("  return description;");
            pw.println("}");
            pw.println();
            pw.println("/** As an alternative, returns the internet domain code for this country, if it exists. */");
            pw.println("public String getInternetDomainCode()");
            pw.println("{");
            pw.println("  return internetDomainCode;");
            pw.println("}");
            pw.println();
            pw.println("}");
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            System.out.println();
        }
    }

    public String enumifyString(String text, boolean uppercase) {
        String enumValue = text.trim();
        if (uppercase) {
            enumValue = enumValue.toUpperCase();
        }
        enumValue = enumValue.replace(" ", "_");
        enumValue = enumValue.replace("-", "_");
        enumValue = enumValue.replace("/", "_");
        enumValue = enumValue.replace("(", "");
        enumValue = enumValue.replace(")", "");
        enumValue = enumValue.replace(",", "");
        enumValue = enumValue.replace("'", "");
        enumValue = enumValue.replace("\"", "");
        enumValue = enumValue.replace(".", "");
        enumValue = enumValue.replace(";", "");
        enumValue = enumValue.replace(":", "");
        enumValue = enumValue.replace("&", "");
        enumValue = enumValue.replace("{", "_");
        enumValue = enumValue.replace("}", "_");
        enumValue = enumValue.replace("#", "_");
        if (uppercase) {
            enumValue = enumValue.replace("^", "_CARET_");
            enumValue = enumValue.replace("<", "_LT_");
            enumValue = enumValue.replace(">", "_GT_");
            enumValue = enumValue.replace("=", "_EQ_");
            enumValue = enumValue.replace("%", "_PCT_");
        } else {
            enumValue = enumValue.replace("^", "_caret_");
            enumValue = enumValue.replace("<", "_lt_");
            enumValue = enumValue.replace(">", "_gt_");
            enumValue = enumValue.replace("=", "_eq_");
            enumValue = enumValue.replace("%", "_pct_");
        }
        enumValue = enumValue.replaceAll("^0", "X_0");
        enumValue = enumValue.replaceAll("^1", "X_1");
        enumValue = enumValue.replaceAll("^2", "X_2");
        enumValue = enumValue.replaceAll("^3", "X_3");
        enumValue = enumValue.replaceAll("^4", "X_4");
        enumValue = enumValue.replaceAll("^5", "X_5");
        enumValue = enumValue.replaceAll("^6", "X_6");
        enumValue = enumValue.replaceAll("^7", "X_7");
        enumValue = enumValue.replaceAll("^8", "X_8");
        enumValue = enumValue.replaceAll("^9", "X_9");
        enumValue = enumValue.replaceAll("(_+)", "_");
        return enumValue;
    }

    private void writeBitmask(String cname, BitmaskT aBitmask) {
        cname = cname.replace(".", "_");
        cname = this.enumifyString(cname, false);
        cname = cname.toLowerCase();
        this.writeCppBitmask(cname, aBitmask);
    }

    private void writeCppBitmask(String bitmaskName, BitmaskT bitmask) {
        try {
            String valueType;
            System.out.println("Bitmask: " + bitmaskName);
            List<BitmaskrowT> subfieldsL = bitmask.getBitmaskrow();
            StringBuilder bitfieldsHeader = new StringBuilder();
            StringBuilder subfieldsHeader = new StringBuilder();
            StringBuilder subfieldsImpl = new StringBuilder();
            int maxidlength = 0;
            int length = bitmask.getLength().intValue();
            --length;
            length |= length >> 1;
            length |= length >> 2;
            length |= length >> 4;
            length |= length >> 8;
            length |= length >> 16;
            switch (++length) {
                case 2: 
                case 8: {
                    valueType = "unsigned char";
                    break;
                }
                case 16: {
                    valueType = "unsigned short";
                    break;
                }
                case 32: {
                    valueType = "unsigned int";
                    break;
                }
                case 64: {
                    valueType = "unsigned long";
                    break;
                }
                default: {
                    throw new Exception("unknown length (" + length + "), bitmask: " + bitmaskName);
                }
            }
            int unusedRows = 0;
            for (int j = 0; j < subfieldsL.size(); ++j) {
                String enumName;
                int idx;
                String enumerationName;
                BitmaskrowT subField = subfieldsL.get(j);
                boolean unused = subField.isUnused() == null ? false : subField.isUnused();
                BigInteger startBit = subField.getId();
                BigInteger endBit = subField.getId2();
                if (endBit == null) {
                    endBit = startBit;
                }
                int fieldWidth = endBit.subtract(startBit).intValue() + 1;
                if (unused) {
                    enumerationName = "unused";
                    if (++unusedRows > 1) {
                        enumerationName = enumerationName + "_" + unusedRows;
                    }
                } else {
                    enumerationName = subField.getName();
                    enumerationName = enumerationName.replace(" ", "");
                    enumerationName = this.enumifyString(enumerationName, false);
                }
                bitfieldsHeader.append("    unsigned int " + enumerationName + ":" + fieldWidth + ";\n");
                ArrayList<String> enumNamesUsed = new ArrayList<String>();
                HashMap<String, Integer> enumValues = new HashMap<String, Integer>();
                HashMap<String, String> enumDescriptions = new HashMap<String, String>();
                int maxValue = 0;
                int usedCount = 1;
                List<EnumrowT> l = subField.getEnumrow();
                int lsize = l == null ? 0 : l.size();
                for (int idx2 = 0; idx2 < lsize; ++idx2) {
                    EnumrowT er = l.get(idx2);
                    StringBuilder u = new StringBuilder();
                    u.append(er.isUnused());
                    boolean enumUnused = Boolean.parseBoolean(u.toString());
                    if (enumUnused) continue;
                    String description = er.getDescription();
                    if (description == null || description.equals("")) {
                        description = "Missing Description";
                    }
                    String enumName2 = this.enumifyString(description, true);
                    maxidlength = Math.max(maxidlength, enumName2.length());
                    int enumValue = er.getId();
                    if (enumNamesUsed.contains(enumName2)) {
                        enumName2 = enumName2 + "_" + usedCount;
                        ++usedCount;
                    }
                    enumNamesUsed.add(enumName2);
                    enumValues.put(enumName2, enumValue);
                    description = description.replace("\"", "");
                    enumDescriptions.put(enumName2, description);
                    if (maxValue >= enumValue) continue;
                    maxValue = enumValue;
                }
                ++maxValue;
                if (unused) continue;
                String template = new String();
                StringBuilder allEnums = new StringBuilder();
                Iterator enumsIter = enumNamesUsed.iterator();
                template = EBVReader.readFileAsString("templates/subfieldEnumTemplate.h");
                for (idx = 0; idx < enumNamesUsed.size(); ++idx) {
                    enumName = (String)enumsIter.next();
                    allEnums.append("    static " + enumerationName + " " + enumName + ";\n");
                }
                template = template.replaceAll("@SUBFIELDNAME", enumerationName);
                template = template.replaceAll("@ENUMS", allEnums.toString());
                subfieldsHeader.append(template);
                template = new String();
                allEnums = new StringBuilder();
                enumsIter = enumNamesUsed.iterator();
                template = EBVReader.readFileAsString("templates/subfieldEnumTemplate.cpp");
                for (idx = 0; idx < enumNamesUsed.size(); ++idx) {
                    enumName = (String)enumsIter.next();
                    int enumValue = (Integer)enumValues.get(enumName);
                    String enumDescription = (String)enumDescriptions.get(enumName);
                    allEnums.append(" " + enumerationName + " " + enumerationName + "::" + enumName + "(" + enumValue + ", " + "\"" + enumDescription + "\");\n");
                }
                template = template.replaceAll("@SUBFIELDNAME", enumerationName);
                template = template.replaceAll("@STARTBIT", startBit.toString());
                template = template.replaceAll("@ENDBIT", endBit.toString());
                template = template.replaceAll("@ENUMSINIT", allEnums.toString());
                subfieldsImpl.append(template);
            }
            File outputFile = new File("src/main/cpp/disenum/" + bitmaskName + ".h");
            outputFile.createNewFile();
            System.out.println("  Writing bitmask " + outputFile.getPath());
            PrintWriter pw = new PrintWriter(outputFile);
            String template = new String();
            template = EBVReader.readFileAsString("templates/bitmaskTemplate.h");
            template = template.replaceAll("@BITMASKUPPERCASE", bitmaskName.toUpperCase());
            template = template.replaceAll("@BITMASK", bitmaskName);
            template = template.replaceAll("@BITFIELDS", bitfieldsHeader.toString());
            template = template.replaceAll("@TYPE", valueType);
            template = template.replaceAll("@ENUMSHEADER", subfieldsHeader.toString());
            pw.print(template);
            pw.flush();
            pw.close();
            outputFile = new File("src/main/cpp/disenum/" + bitmaskName + ".cpp");
            outputFile.createNewFile();
            System.out.println("  Writing bitmask " + outputFile.getPath());
            pw = new PrintWriter(outputFile);
            template = new String();
            template = EBVReader.readFileAsString("templates/bitmaskTemplate.cpp");
            template = template.replaceAll("@BITMASK", bitmaskName);
            template = template.replaceAll("@TYPE", valueType);
            template = template.replaceAll("@ENUMSIMPL", subfieldsImpl.toString());
            pw.print(template);
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            System.out.println("writeBitmask exception:" + e);
        }
    }
}

