package edu.nps.moves.dis;

import java.io.*;

/**
 * Used in UA PDU
 *
 * Copyright (c) 2008-2016, MOVES Institute, Naval Postgraduate School. All
 * rights reserved. This work is licensed under the BSD open source license,
 * available at https://www.movesinstitute.org/licenses/bsd.html
 *
 * @author DMcG
 */
public class ApaData extends Object implements Serializable {

    /**
     * Index of APA parameter
     */
    protected int parameterIndex;

    /**
     * Index of APA parameter
     */
    protected short parameterValue;

    /**
     * Constructor
     */
    public ApaData() {
    }

    public int getMarshalledSize() {
        int marshalSize = 0;

        marshalSize = marshalSize + 2;  // parameterIndex
        marshalSize = marshalSize + 2;  // parameterValue

        return marshalSize;
    }

    public void setParameterIndex(int pParameterIndex) {
        parameterIndex = pParameterIndex;
    }

    public int getParameterIndex() {
        return parameterIndex;
    }

    public void setParameterValue(short pParameterValue) {
        parameterValue = pParameterValue;
    }

    public short getParameterValue() {
        return parameterValue;
    }

    /**
     * Packs a Pdu into the ByteBuffer.
     *
     * @throws java.nio.BufferOverflowException if buff is too small
     * @throws java.nio.ReadOnlyBufferException if buff is read only
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin writing
     * @since ??
     */
    public void marshal(java.nio.ByteBuffer buff) {
        buff.putShort((short) parameterIndex);
        buff.putShort((short) parameterValue);
    } // end of marshal method

    /**
     * Unpacks a Pdu from the underlying data.
     *
     * @throws java.nio.BufferUnderflowException if buff is too small
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin reading
     * @since ??
     */
    public void unmarshal(java.nio.ByteBuffer buff) {
        parameterIndex = (int) (buff.getShort() & 0xFFFF);
        parameterValue = buff.getShort();
    } // end of unmarshal method 


    /*
  * The equals method doesn't always work--mostly it works only on classes that consist only of primitives. Be careful.
     */
    @Override
    public boolean equals(Object obj) {

        if (this == obj) {
            return true;
        }

        if (obj == null) {
            return false;
        }

        if (getClass() != obj.getClass()) {
            return false;
        }

        return equalsImpl(obj);
    }

    /**
     * Compare all fields that contribute to the state, ignoring transient and
     * static fields, for <code>this</code> and the supplied object
     *
     * @param obj the object to compare to
     * @return true if the objects are equal, false otherwise.
     */
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;

        if (!(obj instanceof ApaData)) {
            return false;
        }

        final ApaData rhs = (ApaData) obj;

        if (!(parameterIndex == rhs.parameterIndex)) {
            ivarsEqual = false;
        }
        if (!(parameterValue == rhs.parameterValue)) {
            ivarsEqual = false;
        }

        return ivarsEqual;
    }
} // end of class
