package edu.nps.moves.dis;

import java.io.*;

/**
 * Section 5.2.18. Identifies a unique event in a simulation via the combination
 * of three values
 *
 * Copyright (c) 2008-2016, MOVES Institute, Naval Postgraduate School. All
 * rights reserved. This work is licensed under the BSD open source license,
 * available at https://www.movesinstitute.org/licenses/bsd.html
 *
 * @author DMcG
 */
public class EventID extends Object implements Serializable {

    /**
     * The site ID
     */
    protected int site;

    /**
     * The application ID
     */
    protected int application;

    /**
     * the number of the event
     */
    protected int eventNumber;

    /**
     * Constructor
     */
    public EventID() {
    }

    public int getMarshalledSize() {
        int marshalSize = 0;

        marshalSize = marshalSize + 2;  // site
        marshalSize = marshalSize + 2;  // application
        marshalSize = marshalSize + 2;  // eventNumber

        return marshalSize;
    }

    public void setSite(int pSite) {
        site = pSite;
    }

    public int getSite() {
        return site;
    }

    public void setApplication(int pApplication) {
        application = pApplication;
    }

    public int getApplication() {
        return application;
    }

    public void setEventNumber(int pEventNumber) {
        eventNumber = pEventNumber;
    }

    public int getEventNumber() {
        return eventNumber;
    }

    /**
     * Packs a Pdu into the ByteBuffer.
     *
     * @throws java.nio.BufferOverflowException if buff is too small
     * @throws java.nio.ReadOnlyBufferException if buff is read only
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin writing
     * @since ??
     */
    public void marshal(java.nio.ByteBuffer buff) {
        buff.putShort((short) site);
        buff.putShort((short) application);
        buff.putShort((short) eventNumber);
    } // end of marshal method

    /**
     * Unpacks a Pdu from the underlying data.
     *
     * @throws java.nio.BufferUnderflowException if buff is too small
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin reading
     * @since ??
     */
    public void unmarshal(java.nio.ByteBuffer buff) {
        site = (int) (buff.getShort() & 0xFFFF);
        application = (int) (buff.getShort() & 0xFFFF);
        eventNumber = (int) (buff.getShort() & 0xFFFF);
    } // end of unmarshal method 


    /*
  * The equals method doesn't always work--mostly it works only on classes that consist only of primitives. Be careful.
     */
    @Override
    public boolean equals(Object obj) {

        if (this == obj) {
            return true;
        }

        if (obj == null) {
            return false;
        }

        if (getClass() != obj.getClass()) {
            return false;
        }

        return equalsImpl(obj);
    }

    /**
     * Compare all fields that contribute to the state, ignoring transient and
     * static fields, for <code>this</code> and the supplied object
     *
     * @param obj the object to compare to
     * @return true if the objects are equal, false otherwise.
     */
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;

        if (!(obj instanceof EventID)) {
            return false;
        }

        final EventID rhs = (EventID) obj;

        if (!(site == rhs.site)) {
            ivarsEqual = false;
        }
        if (!(application == rhs.application)) {
            ivarsEqual = false;
        }
        if (!(eventNumber == rhs.eventNumber)) {
            ivarsEqual = false;
        }

        return ivarsEqual;
    }
} // end of class
