package edu.nps.moves.dis;

import java.util.*;
import java.io.*;

/**
 * Section 5.3.12.11: reports the occurance of a significatnt event to the
 * simulation manager. Needs manual intervention to fix padding in variable
 * datums. UNFINISHED.
 *
 * Copyright (c) 2008-2016, MOVES Institute, Naval Postgraduate School. All
 * rights reserved. This work is licensed under the BSD open source license,
 * available at https://www.movesinstitute.org/licenses/bsd.html
 *
 * @author DMcG
 */
public class EventReportReliablePdu extends SimulationManagementWithReliabilityFamilyPdu implements Serializable {

    /**
     * Event type
     */
    protected int eventType;

    /**
     * padding
     */
    protected long pad1;

    /**
     * Fixed datum record count
     */
    protected long numberOfFixedDatumRecords;

    /**
     * variable datum record count
     */
    protected long numberOfVariableDatumRecords;

    /**
     * Fixed datum records
     */
    protected List< FixedDatum> fixedDatumRecords = new ArrayList< FixedDatum>();
    /**
     * Variable datum records
     */
    protected List< VariableDatum> variableDatumRecords = new ArrayList< VariableDatum>();

    /**
     * Constructor
     */
    public EventReportReliablePdu() {
        setPduType((short) 61);
    }

    public int getMarshalledSize() {
        int marshalSize = 0;

        marshalSize = super.getMarshalledSize();
        marshalSize = marshalSize + 2;  // eventType
        marshalSize = marshalSize + 4;  // pad1
        marshalSize = marshalSize + 4;  // numberOfFixedDatumRecords
        marshalSize = marshalSize + 4;  // numberOfVariableDatumRecords
        for (int idx = 0; idx < fixedDatumRecords.size(); idx++) {
            FixedDatum listElement = fixedDatumRecords.get(idx);
            marshalSize = marshalSize + listElement.getMarshalledSize();
        }
        for (int idx = 0; idx < variableDatumRecords.size(); idx++) {
            VariableDatum listElement = variableDatumRecords.get(idx);
            marshalSize = marshalSize + listElement.getMarshalledSize();
        }

        return marshalSize;
    }

    public void setEventType(int pEventType) {
        eventType = pEventType;
    }

    public int getEventType() {
        return eventType;
    }

    public void setPad1(long pPad1) {
        pad1 = pPad1;
    }

    public long getPad1() {
        return pad1;
    }

    public long getNumberOfFixedDatumRecords() {
        return (long) fixedDatumRecords.size();
    }

    /**
     * Note that setting this value will not change the marshalled value. The
     * list whose length this describes is used for that purpose. The
     * getnumberOfFixedDatumRecords method will also be based on the actual list
     * length rather than this value. The method is simply here for java bean
     * completeness.
     */
    public void setNumberOfFixedDatumRecords(long pNumberOfFixedDatumRecords) {
        numberOfFixedDatumRecords = pNumberOfFixedDatumRecords;
    }

    public long getNumberOfVariableDatumRecords() {
        return (long) variableDatumRecords.size();
    }

    /**
     * Note that setting this value will not change the marshalled value. The
     * list whose length this describes is used for that purpose. The
     * getnumberOfVariableDatumRecords method will also be based on the actual
     * list length rather than this value. The method is simply here for java
     * bean completeness.
     */
    public void setNumberOfVariableDatumRecords(long pNumberOfVariableDatumRecords) {
        numberOfVariableDatumRecords = pNumberOfVariableDatumRecords;
    }

    public void setFixedDatumRecords(List<FixedDatum> pFixedDatumRecords) {
        fixedDatumRecords = pFixedDatumRecords;
    }

    public List<FixedDatum> getFixedDatumRecords() {
        return fixedDatumRecords;
    }

    public void setVariableDatumRecords(List<VariableDatum> pVariableDatumRecords) {
        variableDatumRecords = pVariableDatumRecords;
    }

    public List<VariableDatum> getVariableDatumRecords() {
        return variableDatumRecords;
    }

    /**
     * Packs a Pdu into the ByteBuffer.
     *
     * @throws java.nio.BufferOverflowException if buff is too small
     * @throws java.nio.ReadOnlyBufferException if buff is read only
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin writing
     * @since ??
     */
    public void marshal(java.nio.ByteBuffer buff) {
        super.marshal(buff);
        buff.putShort((short) eventType);
        buff.putInt((int) pad1);
        buff.putInt((int) fixedDatumRecords.size());
        buff.putInt((int) variableDatumRecords.size());

        for (int idx = 0; idx < fixedDatumRecords.size(); idx++) {
            FixedDatum aFixedDatum = (FixedDatum) fixedDatumRecords.get(idx);
            aFixedDatum.marshal(buff);
        } // end of list marshalling

        for (int idx = 0; idx < variableDatumRecords.size(); idx++) {
            VariableDatum aVariableDatum = (VariableDatum) variableDatumRecords.get(idx);
            aVariableDatum.marshal(buff);
        } // end of list marshalling

    } // end of marshal method

    /**
     * Unpacks a Pdu from the underlying data.
     *
     * @throws java.nio.BufferUnderflowException if buff is too small
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin reading
     * @since ??
     */
    public void unmarshal(java.nio.ByteBuffer buff) {
        super.unmarshal(buff);

        eventType = (int) (buff.getShort() & 0xFFFF);
        pad1 = buff.getInt();
        numberOfFixedDatumRecords = buff.getInt();
        numberOfVariableDatumRecords = buff.getInt();
        for (int idx = 0; idx < numberOfFixedDatumRecords; idx++) {
            FixedDatum anX = new FixedDatum();
            anX.unmarshal(buff);
            fixedDatumRecords.add(anX);
        }

        for (int idx = 0; idx < numberOfVariableDatumRecords; idx++) {
            VariableDatum anX = new VariableDatum();
            anX.unmarshal(buff);
            variableDatumRecords.add(anX);
        }

    } // end of unmarshal method 


    /*
  * The equals method doesn't always work--mostly it works only on classes that consist only of primitives. Be careful.
     */
    @Override
    public boolean equals(Object obj) {

        if (this == obj) {
            return true;
        }

        if (obj == null) {
            return false;
        }

        if (getClass() != obj.getClass()) {
            return false;
        }

        return equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;

        if (!(obj instanceof EventReportReliablePdu)) {
            return false;
        }

        final EventReportReliablePdu rhs = (EventReportReliablePdu) obj;

        if (!(eventType == rhs.eventType)) {
            ivarsEqual = false;
        }
        if (!(pad1 == rhs.pad1)) {
            ivarsEqual = false;
        }
        if (!(numberOfFixedDatumRecords == rhs.numberOfFixedDatumRecords)) {
            ivarsEqual = false;
        }
        if (!(numberOfVariableDatumRecords == rhs.numberOfVariableDatumRecords)) {
            ivarsEqual = false;
        }

        for (int idx = 0; idx < fixedDatumRecords.size(); idx++) {
            if (!(fixedDatumRecords.get(idx).equals(rhs.fixedDatumRecords.get(idx)))) {
                ivarsEqual = false;
            }
        }

        for (int idx = 0; idx < variableDatumRecords.size(); idx++) {
            if (!(variableDatumRecords.get(idx).equals(rhs.variableDatumRecords.get(idx)))) {
                ivarsEqual = false;
            }
        }

        return ivarsEqual && super.equalsImpl(rhs);
    }
} // end of class
