package edu.nps.moves.dis;

import java.io.*;

/**
 * Section 5.3.9.4 The joining of two or more simulation entities is
 * communicated by this PDU. COMPLETE
 *
 * Copyright (c) 2008-2016, MOVES Institute, Naval Postgraduate School. All
 * rights reserved. This work is licensed under the BSD open source license,
 * available at https://www.movesinstitute.org/licenses/bsd.html
 *
 * @author DMcG
 */
public class IsPartOfPdu extends EntityManagementFamilyPdu implements Serializable {

    /**
     * ID of entity originating PDU
     */
    protected EntityID orginatingEntityID = new EntityID();

    /**
     * ID of entity receiving PDU
     */
    protected EntityID receivingEntityID = new EntityID();

    /**
     * relationship of joined parts
     */
    protected Relationship relationship = new Relationship();

    /**
     * location of part; centroid of part in host's coordinate system. x=range,
     * y=bearing, z=0
     */
    protected Vector3Float partLocation = new Vector3Float();

    /**
     * named location
     */
    protected NamedLocation namedLocationID = new NamedLocation();

    /**
     * entity type
     */
    protected EntityType partEntityType = new EntityType();

    /**
     * Constructor
     */
    public IsPartOfPdu() {
        setPduType((short) 36);
    }

    public int getMarshalledSize() {
        int marshalSize = 0;

        marshalSize = super.getMarshalledSize();
        marshalSize = marshalSize + orginatingEntityID.getMarshalledSize();  // orginatingEntityID
        marshalSize = marshalSize + receivingEntityID.getMarshalledSize();  // receivingEntityID
        marshalSize = marshalSize + relationship.getMarshalledSize();  // relationship
        marshalSize = marshalSize + partLocation.getMarshalledSize();  // partLocation
        marshalSize = marshalSize + namedLocationID.getMarshalledSize();  // namedLocationID
        marshalSize = marshalSize + partEntityType.getMarshalledSize();  // partEntityType

        return marshalSize;
    }

    public void setOrginatingEntityID(EntityID pOrginatingEntityID) {
        orginatingEntityID = pOrginatingEntityID;
    }

    public EntityID getOrginatingEntityID() {
        return orginatingEntityID;
    }

    public void setReceivingEntityID(EntityID pReceivingEntityID) {
        receivingEntityID = pReceivingEntityID;
    }

    public EntityID getReceivingEntityID() {
        return receivingEntityID;
    }

    public void setRelationship(Relationship pRelationship) {
        relationship = pRelationship;
    }

    public Relationship getRelationship() {
        return relationship;
    }

    public void setPartLocation(Vector3Float pPartLocation) {
        partLocation = pPartLocation;
    }

    public Vector3Float getPartLocation() {
        return partLocation;
    }

    public void setNamedLocationID(NamedLocation pNamedLocationID) {
        namedLocationID = pNamedLocationID;
    }

    public NamedLocation getNamedLocationID() {
        return namedLocationID;
    }

    public void setPartEntityType(EntityType pPartEntityType) {
        partEntityType = pPartEntityType;
    }

    public EntityType getPartEntityType() {
        return partEntityType;
    }

    /**
     * Packs a Pdu into the ByteBuffer.
     *
     * @throws java.nio.BufferOverflowException if buff is too small
     * @throws java.nio.ReadOnlyBufferException if buff is read only
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin writing
     * @since ??
     */
    public void marshal(java.nio.ByteBuffer buff) {
        super.marshal(buff);
        orginatingEntityID.marshal(buff);
        receivingEntityID.marshal(buff);
        relationship.marshal(buff);
        partLocation.marshal(buff);
        namedLocationID.marshal(buff);
        partEntityType.marshal(buff);
    } // end of marshal method

    /**
     * Unpacks a Pdu from the underlying data.
     *
     * @throws java.nio.BufferUnderflowException if buff is too small
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin reading
     * @since ??
     */
    public void unmarshal(java.nio.ByteBuffer buff) {
        super.unmarshal(buff);

        orginatingEntityID.unmarshal(buff);
        receivingEntityID.unmarshal(buff);
        relationship.unmarshal(buff);
        partLocation.unmarshal(buff);
        namedLocationID.unmarshal(buff);
        partEntityType.unmarshal(buff);
    } // end of unmarshal method 


    /*
  * The equals method doesn't always work--mostly it works only on classes that consist only of primitives. Be careful.
     */
    @Override
    public boolean equals(Object obj) {

        if (this == obj) {
            return true;
        }

        if (obj == null) {
            return false;
        }

        if (getClass() != obj.getClass()) {
            return false;
        }

        return equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;

        if (!(obj instanceof IsPartOfPdu)) {
            return false;
        }

        final IsPartOfPdu rhs = (IsPartOfPdu) obj;

        if (!(orginatingEntityID.equals(rhs.orginatingEntityID))) {
            ivarsEqual = false;
        }
        if (!(receivingEntityID.equals(rhs.receivingEntityID))) {
            ivarsEqual = false;
        }
        if (!(relationship.equals(rhs.relationship))) {
            ivarsEqual = false;
        }
        if (!(partLocation.equals(rhs.partLocation))) {
            ivarsEqual = false;
        }
        if (!(namedLocationID.equals(rhs.namedLocationID))) {
            ivarsEqual = false;
        }
        if (!(partEntityType.equals(rhs.partEntityType))) {
            ivarsEqual = false;
        }

        return ivarsEqual && super.equalsImpl(rhs);
    }
} // end of class
