package edu.nps.moves.dis;

import java.io.*;

/**
 * discrete ostional relationsihip
 *
 * Copyright (c) 2008-2016, MOVES Institute, Naval Postgraduate School. All
 * rights reserved. This work is licensed under the BSD open source license,
 * available at https://www.movesinstitute.org/licenses/bsd.html
 *
 * @author DMcG
 */
public class NamedLocation extends Object implements Serializable {

    /**
     * station name enumeration
     */
    protected int stationName;

    /**
     * station number
     */
    protected int stationNumber;

    /**
     * Constructor
     */
    public NamedLocation() {
    }

    public int getMarshalledSize() {
        int marshalSize = 0;

        marshalSize = marshalSize + 2;  // stationName
        marshalSize = marshalSize + 2;  // stationNumber

        return marshalSize;
    }

    public void setStationName(int pStationName) {
        stationName = pStationName;
    }

    public int getStationName() {
        return stationName;
    }

    public void setStationNumber(int pStationNumber) {
        stationNumber = pStationNumber;
    }

    public int getStationNumber() {
        return stationNumber;
    }

    /**
     * Packs a Pdu into the ByteBuffer.
     *
     * @throws java.nio.BufferOverflowException if buff is too small
     * @throws java.nio.ReadOnlyBufferException if buff is read only
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin writing
     * @since ??
     */
    public void marshal(java.nio.ByteBuffer buff) {
        buff.putShort((short) stationName);
        buff.putShort((short) stationNumber);
    } // end of marshal method

    /**
     * Unpacks a Pdu from the underlying data.
     *
     * @throws java.nio.BufferUnderflowException if buff is too small
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin reading
     * @since ??
     */
    public void unmarshal(java.nio.ByteBuffer buff) {
        stationName = (int) (buff.getShort() & 0xFFFF);
        stationNumber = (int) (buff.getShort() & 0xFFFF);
    } // end of unmarshal method 


    /*
  * The equals method doesn't always work--mostly it works only on classes that consist only of primitives. Be careful.
     */
    @Override
    public boolean equals(Object obj) {

        if (this == obj) {
            return true;
        }

        if (obj == null) {
            return false;
        }

        if (getClass() != obj.getClass()) {
            return false;
        }

        return equalsImpl(obj);
    }

    /**
     * Compare all fields that contribute to the state, ignoring transient and
     * static fields, for <code>this</code> and the supplied object
     *
     * @param obj the object to compare to
     * @return true if the objects are equal, false otherwise.
     */
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;

        if (!(obj instanceof NamedLocation)) {
            return false;
        }

        final NamedLocation rhs = (NamedLocation) obj;

        if (!(stationName == rhs.stationName)) {
            ivarsEqual = false;
        }
        if (!(stationNumber == rhs.stationNumber)) {
            ivarsEqual = false;
        }

        return ivarsEqual;
    }
} // end of class
