package edu.nps.moves.dis;

import java.io.*;

/**
 * Section 5.2.5.4. Cancel of resupply by either the receiving or supplying
 * entity. COMPLETE
 *
 * Copyright (c) 2008-2016, MOVES Institute, Naval Postgraduate School. All
 * rights reserved. This work is licensed under the BSD open source license,
 * available at https://www.movesinstitute.org/licenses/bsd.html
 *
 * @author DMcG
 */
public class ResupplyCancelPdu extends LogisticsFamilyPdu implements Serializable {

    /**
     * Entity that is receiving service
     */
    protected EntityID receivingEntityID = new EntityID();

    /**
     * Entity that is supplying
     */
    protected EntityID supplyingEntityID = new EntityID();

    /**
     * Constructor
     */
    public ResupplyCancelPdu() {
        setPduType((short) 8);
    }

    public int getMarshalledSize() {
        int marshalSize = 0;

        marshalSize = super.getMarshalledSize();
        marshalSize = marshalSize + receivingEntityID.getMarshalledSize();  // receivingEntityID
        marshalSize = marshalSize + supplyingEntityID.getMarshalledSize();  // supplyingEntityID

        return marshalSize;
    }

    public void setReceivingEntityID(EntityID pReceivingEntityID) {
        receivingEntityID = pReceivingEntityID;
    }

    public EntityID getReceivingEntityID() {
        return receivingEntityID;
    }

    public void setSupplyingEntityID(EntityID pSupplyingEntityID) {
        supplyingEntityID = pSupplyingEntityID;
    }

    public EntityID getSupplyingEntityID() {
        return supplyingEntityID;
    }

    /**
     * Packs a Pdu into the ByteBuffer.
     *
     * @throws java.nio.BufferOverflowException if buff is too small
     * @throws java.nio.ReadOnlyBufferException if buff is read only
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin writing
     * @since ??
     */
    public void marshal(java.nio.ByteBuffer buff) {
        super.marshal(buff);
        receivingEntityID.marshal(buff);
        supplyingEntityID.marshal(buff);
    } // end of marshal method

    /**
     * Unpacks a Pdu from the underlying data.
     *
     * @throws java.nio.BufferUnderflowException if buff is too small
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin reading
     * @since ??
     */
    public void unmarshal(java.nio.ByteBuffer buff) {
        super.unmarshal(buff);

        receivingEntityID.unmarshal(buff);
        supplyingEntityID.unmarshal(buff);
    } // end of unmarshal method 


    /*
  * The equals method doesn't always work--mostly it works only on classes that consist only of primitives. Be careful.
     */
    @Override
    public boolean equals(Object obj) {

        if (this == obj) {
            return true;
        }

        if (obj == null) {
            return false;
        }

        if (getClass() != obj.getClass()) {
            return false;
        }

        return equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;

        if (!(obj instanceof ResupplyCancelPdu)) {
            return false;
        }

        final ResupplyCancelPdu rhs = (ResupplyCancelPdu) obj;

        if (!(receivingEntityID.equals(rhs.receivingEntityID))) {
            ivarsEqual = false;
        }
        if (!(supplyingEntityID.equals(rhs.supplyingEntityID))) {
            ivarsEqual = false;
        }

        return ivarsEqual && super.equalsImpl(rhs);
    }
} // end of class
