package edu.nps.moves.dis;

import java.util.*;
import java.io.*;

/**
 * Section 5.3.12.14: Initializing or changing internal parameter info. Needs
 * manual intervention to fix padding in recrod set PDUs. UNFINISHED
 *
 * Copyright (c) 2008-2016, MOVES Institute, Naval Postgraduate School. All
 * rights reserved. This work is licensed under the BSD open source license,
 * available at https://www.movesinstitute.org/licenses/bsd.html
 *
 * @author DMcG
 */
public class SetRecordReliablePdu extends SimulationManagementWithReliabilityFamilyPdu implements Serializable {

    /**
     * request ID
     */
    protected long requestID;

    /**
     * level of reliability service used for this transaction
     */
    protected short requiredReliabilityService;

    /**
     * padding. The spec is unclear and contradictory here.
     */
    protected int pad1;

    /**
     * padding
     */
    protected short pad2;

    /**
     * Number of record sets in list
     */
    protected long numberOfRecordSets;

    /**
     * record sets
     */
    protected List< RecordSet> recordSets = new ArrayList< RecordSet>();

    /**
     * Constructor
     */
    public SetRecordReliablePdu() {
        setPduType((short) 64);
    }

    public int getMarshalledSize() {
        int marshalSize = 0;

        marshalSize = super.getMarshalledSize();
        marshalSize = marshalSize + 4;  // requestID
        marshalSize = marshalSize + 1;  // requiredReliabilityService
        marshalSize = marshalSize + 2;  // pad1
        marshalSize = marshalSize + 1;  // pad2
        marshalSize = marshalSize + 4;  // numberOfRecordSets
        for (int idx = 0; idx < recordSets.size(); idx++) {
            RecordSet listElement = recordSets.get(idx);
            marshalSize = marshalSize + listElement.getMarshalledSize();
        }

        return marshalSize;
    }

    public void setRequestID(long pRequestID) {
        requestID = pRequestID;
    }

    public long getRequestID() {
        return requestID;
    }

    public void setRequiredReliabilityService(short pRequiredReliabilityService) {
        requiredReliabilityService = pRequiredReliabilityService;
    }

    public short getRequiredReliabilityService() {
        return requiredReliabilityService;
    }

    public void setPad1(int pPad1) {
        pad1 = pPad1;
    }

    public int getPad1() {
        return pad1;
    }

    public void setPad2(short pPad2) {
        pad2 = pPad2;
    }

    public short getPad2() {
        return pad2;
    }

    public long getNumberOfRecordSets() {
        return (long) recordSets.size();
    }

    /**
     * Note that setting this value will not change the marshalled value. The
     * list whose length this describes is used for that purpose. The
     * getnumberOfRecordSets method will also be based on the actual list length
     * rather than this value. The method is simply here for java bean
     * completeness.
     */
    public void setNumberOfRecordSets(long pNumberOfRecordSets) {
        numberOfRecordSets = pNumberOfRecordSets;
    }

    public void setRecordSets(List<RecordSet> pRecordSets) {
        recordSets = pRecordSets;
    }

    public List<RecordSet> getRecordSets() {
        return recordSets;
    }

    /**
     * Packs a Pdu into the ByteBuffer.
     *
     * @throws java.nio.BufferOverflowException if buff is too small
     * @throws java.nio.ReadOnlyBufferException if buff is read only
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin writing
     * @since ??
     */
    public void marshal(java.nio.ByteBuffer buff) {
        super.marshal(buff);
        buff.putInt((int) requestID);
        buff.put((byte) requiredReliabilityService);
        buff.putShort((short) pad1);
        buff.put((byte) pad2);
        buff.putInt((int) recordSets.size());

        for (int idx = 0; idx < recordSets.size(); idx++) {
            RecordSet aRecordSet = (RecordSet) recordSets.get(idx);
            aRecordSet.marshal(buff);
        } // end of list marshalling

    } // end of marshal method

    /**
     * Unpacks a Pdu from the underlying data.
     *
     * @throws java.nio.BufferUnderflowException if buff is too small
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin reading
     * @since ??
     */
    public void unmarshal(java.nio.ByteBuffer buff) {
        super.unmarshal(buff);

        requestID = buff.getInt();
        requiredReliabilityService = (short) (buff.get() & 0xFF);
        pad1 = (int) (buff.getShort() & 0xFFFF);
        pad2 = (short) (buff.get() & 0xFF);
        numberOfRecordSets = buff.getInt();
        for (int idx = 0; idx < numberOfRecordSets; idx++) {
            RecordSet anX = new RecordSet();
            anX.unmarshal(buff);
            recordSets.add(anX);
        }

    } // end of unmarshal method 


    /*
  * The equals method doesn't always work--mostly it works only on classes that consist only of primitives. Be careful.
     */
    @Override
    public boolean equals(Object obj) {

        if (this == obj) {
            return true;
        }

        if (obj == null) {
            return false;
        }

        if (getClass() != obj.getClass()) {
            return false;
        }

        return equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;

        if (!(obj instanceof SetRecordReliablePdu)) {
            return false;
        }

        final SetRecordReliablePdu rhs = (SetRecordReliablePdu) obj;

        if (!(requestID == rhs.requestID)) {
            ivarsEqual = false;
        }
        if (!(requiredReliabilityService == rhs.requiredReliabilityService)) {
            ivarsEqual = false;
        }
        if (!(pad1 == rhs.pad1)) {
            ivarsEqual = false;
        }
        if (!(pad2 == rhs.pad2)) {
            ivarsEqual = false;
        }
        if (!(numberOfRecordSets == rhs.numberOfRecordSets)) {
            ivarsEqual = false;
        }

        for (int idx = 0; idx < recordSets.size(); idx++) {
            if (!(recordSets.get(idx).equals(rhs.recordSets.get(idx)))) {
                ivarsEqual = false;
            }
        }

        return ivarsEqual && super.equalsImpl(rhs);
    }
} // end of class
