package edu.nps.moves.dis;

import java.io.*;

/**
 * Section 5.2.6.3. Start or resume an exercise. COMPLETE
 *
 * Copyright (c) 2008-2016, MOVES Institute, Naval Postgraduate School. All
 * rights reserved. This work is licensed under the BSD open source license,
 * available at https://www.movesinstitute.org/licenses/bsd.html
 *
 * @author DMcG
 */
public class StartResumePdu extends SimulationManagementFamilyPdu implements Serializable {

    /**
     * UTC time at which the simulation shall start or resume
     */
    protected ClockTime realWorldTime = new ClockTime();

    /**
     * Simulation clock time at which the simulation shall start or resume
     */
    protected ClockTime simulationTime = new ClockTime();

    /**
     * Identifier for the request
     */
    protected long requestID;

    /**
     * Constructor
     */
    public StartResumePdu() {
        setPduType((short) 13);
    }

    public int getMarshalledSize() {
        int marshalSize = 0;

        marshalSize = super.getMarshalledSize();
        marshalSize = marshalSize + realWorldTime.getMarshalledSize();  // realWorldTime
        marshalSize = marshalSize + simulationTime.getMarshalledSize();  // simulationTime
        marshalSize = marshalSize + 4;  // requestID

        return marshalSize;
    }

    public void setRealWorldTime(ClockTime pRealWorldTime) {
        realWorldTime = pRealWorldTime;
    }

    public ClockTime getRealWorldTime() {
        return realWorldTime;
    }

    public void setSimulationTime(ClockTime pSimulationTime) {
        simulationTime = pSimulationTime;
    }

    public ClockTime getSimulationTime() {
        return simulationTime;
    }

    public void setRequestID(long pRequestID) {
        requestID = pRequestID;
    }

    public long getRequestID() {
        return requestID;
    }

    /**
     * Packs a Pdu into the ByteBuffer.
     *
     * @throws java.nio.BufferOverflowException if buff is too small
     * @throws java.nio.ReadOnlyBufferException if buff is read only
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin writing
     * @since ??
     */
    public void marshal(java.nio.ByteBuffer buff) {
        super.marshal(buff);
        realWorldTime.marshal(buff);
        simulationTime.marshal(buff);
        buff.putInt((int) requestID);
    } // end of marshal method

    /**
     * Unpacks a Pdu from the underlying data.
     *
     * @throws java.nio.BufferUnderflowException if buff is too small
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin reading
     * @since ??
     */
    public void unmarshal(java.nio.ByteBuffer buff) {
        super.unmarshal(buff);

        realWorldTime.unmarshal(buff);
        simulationTime.unmarshal(buff);
        requestID = buff.getInt();
    } // end of unmarshal method 


    /*
  * The equals method doesn't always work--mostly it works only on classes that consist only of primitives. Be careful.
     */
    @Override
    public boolean equals(Object obj) {

        if (this == obj) {
            return true;
        }

        if (obj == null) {
            return false;
        }

        if (getClass() != obj.getClass()) {
            return false;
        }

        return equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;

        if (!(obj instanceof StartResumePdu)) {
            return false;
        }

        final StartResumePdu rhs = (StartResumePdu) obj;

        if (!(realWorldTime.equals(rhs.realWorldTime))) {
            ivarsEqual = false;
        }
        if (!(simulationTime.equals(rhs.simulationTime))) {
            ivarsEqual = false;
        }
        if (!(requestID == rhs.requestID)) {
            ivarsEqual = false;
        }

        return ivarsEqual && super.equalsImpl(rhs);
    }
} // end of class
