package edu.nps.moves.dis7;

import java.io.*;

/**
 * Section 5.3.12.5: Ack receipt of a start-resume, stop-freeze, create-entity
 * or remove enitty (reliable) pdus. COMPLETE
 *
 * Copyright (c) 2008-2016, MOVES Institute, Naval Postgraduate School. All
 * rights reserved. This work is licensed under the BSD open source license,
 * available at https://www.movesinstitute.org/licenses/bsd.html
 *
 * @author DMcG
 */
public class AcknowledgeReliablePdu extends SimulationManagementWithReliabilityFamilyPdu implements Serializable {

    /**
     * ack flags
     */
    protected int acknowledgeFlag;

    /**
     * response flags
     */
    protected int responseFlag;

    /**
     * Request ID
     */
    protected long requestID;

    /**
     * Constructor
     */
    public AcknowledgeReliablePdu() {
        setPduType((short) 55);
    }

    public int getMarshalledSize() {
        int marshalSize = 0;

        marshalSize = super.getMarshalledSize();
        marshalSize = marshalSize + 2;  // acknowledgeFlag
        marshalSize = marshalSize + 2;  // responseFlag
        marshalSize = marshalSize + 4;  // requestID

        return marshalSize;
    }

    public void setAcknowledgeFlag(int pAcknowledgeFlag) {
        acknowledgeFlag = pAcknowledgeFlag;
    }

    public int getAcknowledgeFlag() {
        return acknowledgeFlag;
    }

    public void setResponseFlag(int pResponseFlag) {
        responseFlag = pResponseFlag;
    }

    public int getResponseFlag() {
        return responseFlag;
    }

    public void setRequestID(long pRequestID) {
        requestID = pRequestID;
    }

    public long getRequestID() {
        return requestID;
    }

    public void marshal(DataOutputStream dos) {
        super.marshal(dos);
        try {
            dos.writeShort((short) acknowledgeFlag);
            dos.writeShort((short) responseFlag);
            dos.writeInt((int) requestID);
        } // end try 
        catch (Exception e) {
            System.out.println(e);
        }
    } // end of marshal method

    public void unmarshal(DataInputStream dis) {
        super.unmarshal(dis);

        try {
            acknowledgeFlag = (int) dis.readUnsignedShort();
            responseFlag = (int) dis.readUnsignedShort();
            requestID = dis.readInt();
        } // end try 
        catch (Exception e) {
            System.out.println(e);
        }
    } // end of unmarshal method 

    /**
     * Packs a Pdu into the ByteBuffer.
     *
     * @throws java.nio.BufferOverflowException if buff is too small
     * @throws java.nio.ReadOnlyBufferException if buff is read only
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin writing
     * @since ??
     */
    public void marshal(java.nio.ByteBuffer buff) {
        super.marshal(buff);
        buff.putShort((short) acknowledgeFlag);
        buff.putShort((short) responseFlag);
        buff.putInt((int) requestID);
    } // end of marshal method

    /**
     * Unpacks a Pdu from the underlying data.
     *
     * @throws java.nio.BufferUnderflowException if buff is too small
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin reading
     * @since ??
     */
    public void unmarshal(java.nio.ByteBuffer buff) {
        super.unmarshal(buff);

        acknowledgeFlag = (int) (buff.getShort() & 0xFFFF);
        responseFlag = (int) (buff.getShort() & 0xFFFF);
        requestID = buff.getInt();
    } // end of unmarshal method 


    /*
  * The equals method doesn't always work--mostly it works only on classes that consist only of primitives. Be careful.
     */
    @Override
    public boolean equals(Object obj) {

        if (this == obj) {
            return true;
        }

        if (obj == null) {
            return false;
        }

        if (getClass() != obj.getClass()) {
            return false;
        }

        return equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;

        if (!(obj instanceof AcknowledgeReliablePdu)) {
            return false;
        }

        final AcknowledgeReliablePdu rhs = (AcknowledgeReliablePdu) obj;

        if (!(acknowledgeFlag == rhs.acknowledgeFlag)) {
            ivarsEqual = false;
        }
        if (!(responseFlag == rhs.responseFlag)) {
            ivarsEqual = false;
        }
        if (!(requestID == rhs.requestID)) {
            ivarsEqual = false;
        }

        return ivarsEqual && super.equalsImpl(rhs);
    }
} // end of class
