package edu.nps.moves.dis7;

import java.io.*;

/**
 * Identifies the type and organization of an aggregate. Section 6.2.5
 *
 * Copyright (c) 2008-2016, MOVES Institute, Naval Postgraduate School. All
 * rights reserved. This work is licensed under the BSD open source license,
 * available at https://www.movesinstitute.org/licenses/bsd.html
 *
 * @author DMcG
 */
public class AggregateType extends Object implements Serializable {

    /**
     * Grouping criterion used to group the aggregate. Enumeration from EBV
     * document
     */
    protected short aggregateKind;

    /**
     * Domain of entity (air, surface, subsurface, space, etc) Zero means domain
     * does not apply.
     */
    protected short domain;

    /**
     * country to which the design of the entity is attributed
     */
    protected int country;

    /**
     * category of entity
     */
    protected short category;

    /**
     * subcategory of entity
     */
    protected short subcategory;

    /**
     * specific info based on subcategory field. specific is a reserved word in
     * sql.
     */
    protected short specificInfo;

    /**
     * extra information needed to describe the aggregate
     */
    protected short extra;

    /**
     * Constructor
     */
    public AggregateType() {
    }

    public int getMarshalledSize() {
        int marshalSize = 0;

        marshalSize = marshalSize + 1;  // aggregateKind
        marshalSize = marshalSize + 1;  // domain
        marshalSize = marshalSize + 2;  // country
        marshalSize = marshalSize + 1;  // category
        marshalSize = marshalSize + 1;  // subcategory
        marshalSize = marshalSize + 1;  // specificInfo
        marshalSize = marshalSize + 1;  // extra

        return marshalSize;
    }

    public void setAggregateKind(short pAggregateKind) {
        aggregateKind = pAggregateKind;
    }

    public short getAggregateKind() {
        return aggregateKind;
    }

    public void setDomain(short pDomain) {
        domain = pDomain;
    }

    public short getDomain() {
        return domain;
    }

    public void setCountry(int pCountry) {
        country = pCountry;
    }

    public int getCountry() {
        return country;
    }

    public void setCategory(short pCategory) {
        category = pCategory;
    }

    public short getCategory() {
        return category;
    }

    public void setSubcategory(short pSubcategory) {
        subcategory = pSubcategory;
    }

    public short getSubcategory() {
        return subcategory;
    }

    public void setSpecificInfo(short pSpecificInfo) {
        specificInfo = pSpecificInfo;
    }

    public short getSpecificInfo() {
        return specificInfo;
    }

    public void setExtra(short pExtra) {
        extra = pExtra;
    }

    public short getExtra() {
        return extra;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeByte((byte) aggregateKind);
            dos.writeByte((byte) domain);
            dos.writeShort((short) country);
            dos.writeByte((byte) category);
            dos.writeByte((byte) subcategory);
            dos.writeByte((byte) specificInfo);
            dos.writeByte((byte) extra);
        } // end try 
        catch (Exception e) {
            System.out.println(e);
        }
    } // end of marshal method

    public void unmarshal(DataInputStream dis) {
        try {
            aggregateKind = (short) dis.readUnsignedByte();
            domain = (short) dis.readUnsignedByte();
            country = (int) dis.readUnsignedShort();
            category = (short) dis.readUnsignedByte();
            subcategory = (short) dis.readUnsignedByte();
            specificInfo = (short) dis.readUnsignedByte();
            extra = (short) dis.readUnsignedByte();
        } // end try 
        catch (Exception e) {
            System.out.println(e);
        }
    } // end of unmarshal method 

    /**
     * Packs a Pdu into the ByteBuffer.
     *
     * @throws java.nio.BufferOverflowException if buff is too small
     * @throws java.nio.ReadOnlyBufferException if buff is read only
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin writing
     * @since ??
     */
    public void marshal(java.nio.ByteBuffer buff) {
        buff.put((byte) aggregateKind);
        buff.put((byte) domain);
        buff.putShort((short) country);
        buff.put((byte) category);
        buff.put((byte) subcategory);
        buff.put((byte) specificInfo);
        buff.put((byte) extra);
    } // end of marshal method

    /**
     * Unpacks a Pdu from the underlying data.
     *
     * @throws java.nio.BufferUnderflowException if buff is too small
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin reading
     * @since ??
     */
    public void unmarshal(java.nio.ByteBuffer buff) {
        aggregateKind = (short) (buff.get() & 0xFF);
        domain = (short) (buff.get() & 0xFF);
        country = (int) (buff.getShort() & 0xFFFF);
        category = (short) (buff.get() & 0xFF);
        subcategory = (short) (buff.get() & 0xFF);
        specificInfo = (short) (buff.get() & 0xFF);
        extra = (short) (buff.get() & 0xFF);
    } // end of unmarshal method 


    /*
  * The equals method doesn't always work--mostly it works only on classes that consist only of primitives. Be careful.
     */
    @Override
    public boolean equals(Object obj) {

        if (this == obj) {
            return true;
        }

        if (obj == null) {
            return false;
        }

        if (getClass() != obj.getClass()) {
            return false;
        }

        return equalsImpl(obj);
    }

    /**
     * Compare all fields that contribute to the state, ignoring transient and
     * static fields, for <code>this</code> and the supplied object
     *
     * @param obj the object to compare to
     * @return true if the objects are equal, false otherwise.
     */
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;

        if (!(obj instanceof AggregateType)) {
            return false;
        }

        final AggregateType rhs = (AggregateType) obj;

        if (!(aggregateKind == rhs.aggregateKind)) {
            ivarsEqual = false;
        }
        if (!(domain == rhs.domain)) {
            ivarsEqual = false;
        }
        if (!(country == rhs.country)) {
            ivarsEqual = false;
        }
        if (!(category == rhs.category)) {
            ivarsEqual = false;
        }
        if (!(subcategory == rhs.subcategory)) {
            ivarsEqual = false;
        }
        if (!(specificInfo == rhs.specificInfo)) {
            ivarsEqual = false;
        }
        if (!(extra == rhs.extra)) {
            ivarsEqual = false;
        }

        return ivarsEqual;
    }
} // end of class
