package edu.nps.moves.dis7;

import java.io.*;

/**
 * articulated parts for movable parts and a combination of moveable/attached
 * parts of an entity. Section 6.2.94.2
 *
 * Copyright (c) 2008-2016, MOVES Institute, Naval Postgraduate School. All
 * rights reserved. This work is licensed under the BSD open source license,
 * available at https://www.movesinstitute.org/licenses/bsd.html
 *
 * @author DMcG
 */
public class ArticulatedParts extends VariableParameter implements Serializable {

    /**
     * indicate the change of any parameter for any articulated part. Starts at
     * zero, incremented for each change
     */
    protected short changeIndicator = (short) 0;

    /**
     * the identification of the articulated part to which this articulation
     * parameter is attached. This field shall be specified by a 16-bit unsigned
     * integer. This field shall contain the value zero if the articulated part
     * is attached directly to the entity.
     */
    protected int partAttachedTo = (int) 0;

    /**
     * the type of parameter represented, 32 bit enumeration
     */
    protected long parameterType;

    /**
     * The definition of the 64 bits shall be determined based on the type of
     * parameter specified in the Parameter Type field
     */
    protected float parameterValue;

    /**
     * padding
     */
    protected int padding = (int) 0;
    
    /**
     * Constructor
     */
    public ArticulatedParts() {
        recordType = 0;
    }

    public int getMarshalledSize() {
        int marshalSize = 0;

        marshalSize = marshalSize + 1;  // recordType
        marshalSize = marshalSize + 1;  // changeIndicator
        marshalSize = marshalSize + 2;  // partAttachedTo
        marshalSize = marshalSize + 4;  // parameterType
        marshalSize = marshalSize + 4;  // parameterValue
        marshalSize = marshalSize + 4;  // padding

        return marshalSize;
    }

    public void setChangeIndicator(short pChangeIndicator) {
        changeIndicator = pChangeIndicator;
    }

    public short getChangeIndicator() {
        return changeIndicator;
    }

    public void setPartAttachedTo(int pPartAttachedTo) {
        partAttachedTo = pPartAttachedTo;
    }

    public int getPartAttachedTo() {
        return partAttachedTo;
    }

    public void setParameterType(long pParameterType) {
        parameterType = pParameterType;
    }

    public long getParameterType() {
        return parameterType;
    }

    public void setParameterValue(float pParameterValue) {
        parameterValue = pParameterValue;
    }

    public float getParameterValue() {
        return parameterValue;
    }

    public void setPadding(int pPadding) {
        padding = pPadding;
    }

    public int getPadding() {
        return padding;
    }    
    
    public void marshal(DataOutputStream dos) {
        try {
            super.marshal(dos);
            dos.writeByte((byte) changeIndicator);
            dos.writeShort((short) partAttachedTo);
            dos.writeInt((int) parameterType);
            dos.writeFloat(parameterValue);
            dos.writeInt(padding);
        } // end try 
        catch (Exception e) {
            System.out.println(e);
        }
    } // end of marshal method

    public void unmarshal(DataInputStream dis) {
        try {
            changeIndicator = (short) dis.readUnsignedByte();
            partAttachedTo = (int) dis.readUnsignedShort();
            parameterType = dis.readInt();
            parameterValue = dis.readFloat();
            padding = dis.readInt();
        } // end try 
        catch (Exception e) {
            System.out.println(e);
        }
    } // end of unmarshal method 

    /**
     * Packs a Pdu into the ByteBuffer.
     *
     * @throws java.nio.BufferOverflowException if buff is too small
     * @throws java.nio.ReadOnlyBufferException if buff is read only
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin writing
     * @since ??
     */
    public void marshal(java.nio.ByteBuffer buff) {
        super.marshal(buff);
        buff.put((byte) changeIndicator);
        buff.putShort((short) partAttachedTo);
        buff.putInt((int) parameterType);
        buff.putFloat((float) parameterValue);
        buff.putInt(padding);
    } // end of marshal method

    /**
     * Unpacks a Pdu from the underlying data.
     *
     * @throws java.nio.BufferUnderflowException if buff is too small
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin reading
     * @since ??
     */
    public void unmarshal(java.nio.ByteBuffer buff) {
        changeIndicator = (short) (buff.get() & 0xFF);
        partAttachedTo = (int) (buff.getShort() & 0xFFFF);
        parameterType = buff.getInt();
        parameterValue = buff.getFloat();
        padding = buff.getInt();
    } // end of unmarshal method 


    /*
  * The equals method doesn't always work--mostly it works only on classes that consist only of primitives. Be careful.
     */
    @Override
    public boolean equals(Object obj) {

        if (this == obj) {
            return true;
        }

        if (obj == null) {
            return false;
        }

        if (getClass() != obj.getClass()) {
            return false;
        }

        return equalsImpl(obj);
    }

    /**
     * Compare all fields that contribute to the state, ignoring transient and
     * static fields, for <code>this</code> and the supplied object
     *
     * @param obj the object to compare to
     * @return true if the objects are equal, false otherwise.
     */
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;

        if (!(obj instanceof ArticulatedParts)) {
            return false;
        }

        final ArticulatedParts rhs = (ArticulatedParts) obj;

        if (!(recordType == rhs.recordType)) {
            ivarsEqual = false;
        }
        if (!(changeIndicator == rhs.changeIndicator)) {
            ivarsEqual = false;
        }
        if (!(partAttachedTo == rhs.partAttachedTo)) {
            ivarsEqual = false;
        }
        if (!(parameterType == rhs.parameterType)) {
            ivarsEqual = false;
        }
        if (!(parameterValue == rhs.parameterValue)) {
            ivarsEqual = false;
        }
        if (!(padding == rhs.padding)) {
            ivarsEqual = false;
        }
        
        return ivarsEqual;
    }
} // end of class
