package edu.nps.moves.dis7;

import java.io.*;

/**
 * Identifies the type of Entity
 *
 * Copyright (c) 2008-2016, MOVES Institute, Naval Postgraduate School. All
 * rights reserved. This work is licensed under the BSD open source license,
 * available at https://www.movesinstitute.org/licenses/bsd.html
 *
 * @author DMcG
 */
public class EntityType extends Object implements Serializable {

    /**
     * Kind of entity
     */
    protected short entityKind;

    /**
     * Domain of entity (air, surface, subsurface, space, etc)
     */
    protected short domain;

    /**
     * country to which the design of the entity is attributed
     */
    protected int country;

    /**
     * category of entity
     */
    protected short category;

    /**
     * subcategory of entity
     */
    protected short subcategory;

    /**
     * specific info based on subcategory field. Renamed from specific because
     * that is a reserved word in SQL.
     */
    protected short specific;

    protected short extra;

    /**
     * Constructor
     */
    public EntityType() {
    }

    public int getMarshalledSize() {
        int marshalSize = 0;

        marshalSize = marshalSize + 1;  // entityKind
        marshalSize = marshalSize + 1;  // domain
        marshalSize = marshalSize + 2;  // country
        marshalSize = marshalSize + 1;  // category
        marshalSize = marshalSize + 1;  // subcategory
        marshalSize = marshalSize + 1;  // specific
        marshalSize = marshalSize + 1;  // extra

        return marshalSize;
    }

    public void setEntityKind(short pEntityKind) {
        entityKind = pEntityKind;
    }

    public short getEntityKind() {
        return entityKind;
    }

    public void setDomain(short pDomain) {
        domain = pDomain;
    }

    public short getDomain() {
        return domain;
    }

    public void setCountry(int pCountry) {
        country = pCountry;
    }

    public int getCountry() {
        return country;
    }

    public void setCategory(short pCategory) {
        category = pCategory;
    }

    public short getCategory() {
        return category;
    }

    public void setSubcategory(short pSubcategory) {
        subcategory = pSubcategory;
    }

    public short getSubcategory() {
        return subcategory;
    }

    public void setSpecific(short pSpecific) {
        specific = pSpecific;
    }

    public short getSpecific() {
        return specific;
    }

    public void setExtra(short pExtra) {
        extra = pExtra;
    }

    public short getExtra() {
        return extra;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeByte((byte) entityKind);
            dos.writeByte((byte) domain);
            dos.writeShort((short) country);
            dos.writeByte((byte) category);
            dos.writeByte((byte) subcategory);
            dos.writeByte((byte) specific);
            dos.writeByte((byte) extra);
        } // end try 
        catch (Exception e) {
            System.out.println(e);
        }
    } // end of marshal method

    public void unmarshal(DataInputStream dis) {
        try {
            entityKind = (short) dis.readUnsignedByte();
            domain = (short) dis.readUnsignedByte();
            country = (int) dis.readUnsignedShort();
            category = (short) dis.readUnsignedByte();
            subcategory = (short) dis.readUnsignedByte();
            specific = (short) dis.readUnsignedByte();
            extra = (short) dis.readUnsignedByte();
        } // end try 
        catch (Exception e) {
            System.out.println(e);
        }
    } // end of unmarshal method 

    /**
     * Packs a Pdu into the ByteBuffer.
     *
     * @throws java.nio.BufferOverflowException if buff is too small
     * @throws java.nio.ReadOnlyBufferException if buff is read only
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin writing
     * @since ??
     */
    public void marshal(java.nio.ByteBuffer buff) {
        buff.put((byte) entityKind);
        buff.put((byte) domain);
        buff.putShort((short) country);
        buff.put((byte) category);
        buff.put((byte) subcategory);
        buff.put((byte) specific);
        buff.put((byte) extra);
    } // end of marshal method

    /**
     * Unpacks a Pdu from the underlying data.
     *
     * @throws java.nio.BufferUnderflowException if buff is too small
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin reading
     * @since ??
     */
    public void unmarshal(java.nio.ByteBuffer buff) {
        entityKind = (short) (buff.get() & 0xFF);
        domain = (short) (buff.get() & 0xFF);
        country = (int) (buff.getShort() & 0xFFFF);
        category = (short) (buff.get() & 0xFF);
        subcategory = (short) (buff.get() & 0xFF);
        specific = (short) (buff.get() & 0xFF);
        extra = (short) (buff.get() & 0xFF);
    } // end of unmarshal method 


    /*
  * The equals method doesn't always work--mostly it works only on classes that consist only of primitives. Be careful.
     */
    @Override
    public boolean equals(Object obj) {

        if (this == obj) {
            return true;
        }

        if (obj == null) {
            return false;
        }

        if (getClass() != obj.getClass()) {
            return false;
        }

        return equalsImpl(obj);
    }

    /**
     * Compare all fields that contribute to the state, ignoring transient and
     * static fields, for <code>this</code> and the supplied object
     *
     * @param obj the object to compare to
     * @return true if the objects are equal, false otherwise.
     */
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;

        if (!(obj instanceof EntityType)) {
            return false;
        }

        final EntityType rhs = (EntityType) obj;

        if (!(entityKind == rhs.entityKind)) {
            ivarsEqual = false;
        }
        if (!(domain == rhs.domain)) {
            ivarsEqual = false;
        }
        if (!(country == rhs.country)) {
            ivarsEqual = false;
        }
        if (!(category == rhs.category)) {
            ivarsEqual = false;
        }
        if (!(subcategory == rhs.subcategory)) {
            ivarsEqual = false;
        }
        if (!(specific == rhs.specific)) {
            ivarsEqual = false;
        }
        if (!(extra == rhs.extra)) {
            ivarsEqual = false;
        }

        return ivarsEqual;
    }
} // end of class
