package edu.nps.moves.dis7;

import java.io.*;

/**
 * Incomplete environment record; requires hand coding to fix. Section 6.2.31.1
 *
 * Copyright (c) 2008-2016, MOVES Institute, Naval Postgraduate School. All
 * rights reserved. This work is licensed under the BSD open source license,
 * available at https://www.movesinstitute.org/licenses/bsd.html
 *
 * @author DMcG
 */
public class Environment extends Object implements Serializable {

    /**
     * type
     */
    protected long environmentType;

    /**
     * length, in bits, of the record
     */
    protected int length;

    /**
     * identifies the sequntially numbered record index
     */
    protected short index;

    /**
     * padding
     */
    protected short padding = (short) 0;

    /**
     * Constructor
     */
    public Environment() {
    }

    public int getMarshalledSize() {
        int marshalSize = 0;

        marshalSize = marshalSize + 4;  // environmentType
        marshalSize = marshalSize + 2;  // length
        marshalSize = marshalSize + 1;  // index
        marshalSize = marshalSize + 1;  // padding

        return marshalSize;
    }

    public void setEnvironmentType(long pEnvironmentType) {
        environmentType = pEnvironmentType;
    }

    public long getEnvironmentType() {
        return environmentType;
    }

    public void setLength(int pLength) {
        length = pLength;
    }

    public int getLength() {
        return length;
    }

    public void setIndex(short pIndex) {
        index = pIndex;
    }

    public short getIndex() {
        return index;
    }

    public void setPadding(short pPadding) {
        padding = pPadding;
    }

    public short getPadding() {
        return padding;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeInt((int) environmentType);
            dos.writeShort((short) length);
            dos.writeByte((byte) index);
            dos.writeByte((byte) padding);
        } // end try 
        catch (Exception e) {
            System.out.println(e);
        }
    } // end of marshal method

    public void unmarshal(DataInputStream dis) {
        try {
            environmentType = dis.readInt();
            length = (int) dis.readUnsignedShort();
            index = (short) dis.readUnsignedByte();
            padding = (short) dis.readUnsignedByte();
        } // end try 
        catch (Exception e) {
            System.out.println(e);
        }
    } // end of unmarshal method 

    /**
     * Packs a Pdu into the ByteBuffer.
     *
     * @throws java.nio.BufferOverflowException if buff is too small
     * @throws java.nio.ReadOnlyBufferException if buff is read only
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin writing
     * @since ??
     */
    public void marshal(java.nio.ByteBuffer buff) {
        buff.putInt((int) environmentType);
        buff.putShort((short) length);
        buff.put((byte) index);
        buff.put((byte) padding);
    } // end of marshal method

    /**
     * Unpacks a Pdu from the underlying data.
     *
     * @throws java.nio.BufferUnderflowException if buff is too small
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin reading
     * @since ??
     */
    public void unmarshal(java.nio.ByteBuffer buff) {
        environmentType = buff.getInt();
        length = (int) (buff.getShort() & 0xFFFF);
        index = (short) (buff.get() & 0xFF);
        padding = (short) (buff.get() & 0xFF);
    } // end of unmarshal method 


    /*
  * The equals method doesn't always work--mostly it works only on classes that consist only of primitives. Be careful.
     */
    @Override
    public boolean equals(Object obj) {

        if (this == obj) {
            return true;
        }

        if (obj == null) {
            return false;
        }

        if (getClass() != obj.getClass()) {
            return false;
        }

        return equalsImpl(obj);
    }

    /**
     * Compare all fields that contribute to the state, ignoring transient and
     * static fields, for <code>this</code> and the supplied object
     *
     * @param obj the object to compare to
     * @return true if the objects are equal, false otherwise.
     */
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;

        if (!(obj instanceof Environment)) {
            return false;
        }

        final Environment rhs = (Environment) obj;

        if (!(environmentType == rhs.environmentType)) {
            ivarsEqual = false;
        }
        if (!(length == rhs.length)) {
            ivarsEqual = false;
        }
        if (!(index == rhs.index)) {
            ivarsEqual = false;
        }
        if (!(padding == rhs.padding)) {
            ivarsEqual = false;
        }

        return ivarsEqual;
    }
} // end of class
