package edu.nps.moves.dis7;

import java.io.*;

/**
 * Three floating point values representing an orientation, psi, theta, and phi,
 * aka the euler angles, in radians. Section 6.2.33
 *
 * Copyright (c) 2008-2016, MOVES Institute, Naval Postgraduate School. All
 * rights reserved. This work is licensed under the BSD open source license,
 * available at https://www.movesinstitute.org/licenses/bsd.html
 *
 * @author DMcG
 */
public class EulerAngles extends Object implements Serializable {

    protected float psi;

    protected float theta;

    protected float phi;

    /**
     * Constructor
     */
    public EulerAngles() {
    }

    public int getMarshalledSize() {
        int marshalSize = 0;

        marshalSize = marshalSize + 4;  // psi
        marshalSize = marshalSize + 4;  // theta
        marshalSize = marshalSize + 4;  // phi

        return marshalSize;
    }

    public void setPsi(float pPsi) {
        psi = pPsi;
    }

    public float getPsi() {
        return psi;
    }

    public void setTheta(float pTheta) {
        theta = pTheta;
    }

    public float getTheta() {
        return theta;
    }

    public void setPhi(float pPhi) {
        phi = pPhi;
    }

    public float getPhi() {
        return phi;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeFloat((float) psi);
            dos.writeFloat((float) theta);
            dos.writeFloat((float) phi);
        } // end try 
        catch (Exception e) {
            System.out.println(e);
        }
    } // end of marshal method

    public void unmarshal(DataInputStream dis) {
        try {
            psi = dis.readFloat();
            theta = dis.readFloat();
            phi = dis.readFloat();
        } // end try 
        catch (Exception e) {
            System.out.println(e);
        }
    } // end of unmarshal method 

    /**
     * Packs a Pdu into the ByteBuffer.
     *
     * @throws java.nio.BufferOverflowException if buff is too small
     * @throws java.nio.ReadOnlyBufferException if buff is read only
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin writing
     * @since ??
     */
    public void marshal(java.nio.ByteBuffer buff) {
        buff.putFloat((float) psi);
        buff.putFloat((float) theta);
        buff.putFloat((float) phi);
    } // end of marshal method

    /**
     * Unpacks a Pdu from the underlying data.
     *
     * @throws java.nio.BufferUnderflowException if buff is too small
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin reading
     * @since ??
     */
    public void unmarshal(java.nio.ByteBuffer buff) {
        psi = buff.getFloat();
        theta = buff.getFloat();
        phi = buff.getFloat();
    } // end of unmarshal method 


    /*
  * The equals method doesn't always work--mostly it works only on classes that consist only of primitives. Be careful.
     */
    @Override
    public boolean equals(Object obj) {

        if (this == obj) {
            return true;
        }

        if (obj == null) {
            return false;
        }

        if (getClass() != obj.getClass()) {
            return false;
        }

        return equalsImpl(obj);
    }

    /**
     * Compare all fields that contribute to the state, ignoring transient and
     * static fields, for <code>this</code> and the supplied object
     *
     * @param obj the object to compare to
     * @return true if the objects are equal, false otherwise.
     */
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;

        if (!(obj instanceof EulerAngles)) {
            return false;
        }

        final EulerAngles rhs = (EulerAngles) obj;

        if (!(psi == rhs.psi)) {
            ivarsEqual = false;
        }
        if (!(theta == rhs.theta)) {
            ivarsEqual = false;
        }
        if (!(phi == rhs.phi)) {
            ivarsEqual = false;
        }

        return ivarsEqual;
    }
} // end of class
