package edu.nps.moves.dis7;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;

/**
 *
 * @author fo
 */
public class IFFLayer1 extends Object implements Serializable {

    /**
     * Identify the entity that is the source of the emissions
     */
    protected EntityID emittingEntityId = new EntityID();

    /**
     * Contain a number generated by the issuing simulator to associate related
     * events.
     */
    protected EventIdentifier eventId = new EventIdentifier();

    /**
     * Relative location of a designated primary antenna for this IFF system
     */
    protected Vector3Float relativeAntennaLocation = new Vector3Float();

    /**
     * A specific interrogator or transponder system for the emitting system
     */
    protected SystemIdentifier systemId = new SystemIdentifier();

    /**
     * a unique decimal number assigned to this interrogator or transponder to
     * distinguish it from multiple interrogators or transponders that are
     * associated with the same entity
     */
    protected short systemDesignator;

    /**
     * variable format field containing 8 bits of data whose meaning is defined
     * for each specific system
     */
    protected short systemSpecificData;

    /**
     * Identify certain basic operational data for the IFF emitting system
     */
    protected FundamentalOperationalData fundamentalOperationalData = new FundamentalOperationalData();

    public IFFLayer1() {
    }

    public int getMarshalledSize() {
        int marshalSize = 0;

        marshalSize = marshalSize + emittingEntityId.getMarshalledSize();//emittingEntityId
        marshalSize = marshalSize + eventId.getMarshalledSize();//eventId
        marshalSize = marshalSize + relativeAntennaLocation.getMarshalledSize();//relativeAntennaLocation
        marshalSize = marshalSize + systemId.getMarshalledSize();//systemId
        marshalSize = marshalSize + 1;//systemDesignator
        marshalSize = marshalSize + 1;//systemSpecificData
        marshalSize = marshalSize + fundamentalOperationalData.getMarshalledSize();//fundamentalOperationalData
        return marshalSize;
    }

    public EntityID getEmittingEntityId() {
        return emittingEntityId;
    }

    public void setEmittingEntityId(EntityID emittingEntityId) {
        this.emittingEntityId = emittingEntityId;
    }

    public EventIdentifier getEventId() {
        return eventId;
    }

    public void setEventId(EventIdentifier eventId) {
        this.eventId = eventId;
    }

    public Vector3Float getRelativeAntennaLocation() {
        return relativeAntennaLocation;
    }

    public void setRelativeAntennaLocation(Vector3Float relativeAntennaLocation) {
        this.relativeAntennaLocation = relativeAntennaLocation;
    }

    public SystemIdentifier getSystemId() {
        return systemId;
    }

    public void setSystemId(SystemIdentifier systemId) {
        this.systemId = systemId;
    }

    public short getSystemDesignator() {
        return systemDesignator;
    }

    public void setSystemDesignator(short systemDesignator) {
        this.systemDesignator = systemDesignator;
    }

    public short getSystemSpecificData() {
        return systemSpecificData;
    }

    public void setSystemSpecificData(short systemSpecificData) {
        this.systemSpecificData = systemSpecificData;
    }

    public FundamentalOperationalData getFundamentalOperationalData() {
        return fundamentalOperationalData;
    }

    public void setFundamentalOperationalData(FundamentalOperationalData fundamentalOperationalData) {
        this.fundamentalOperationalData = fundamentalOperationalData;
    }

    public void marshal(DataOutputStream dos) {
        try {
            emittingEntityId.marshal(dos);
            eventId.marshal(dos);
            relativeAntennaLocation.marshal(dos);
            systemId.marshal(dos);
            dos.writeByte((byte) systemDesignator);
            dos.writeByte((byte) systemSpecificData);
            fundamentalOperationalData.marshal(dos);
        } // end try 
        catch (Exception e) {
            System.out.println(e);
        }
    } // end of marshal method 

    public void unmarshal(DataInputStream dis) {

        try {
            emittingEntityId.unmarshal(dis);
            eventId.unmarshal(dis);
            relativeAntennaLocation.unmarshal(dis);
            systemId.unmarshal(dis);
            systemDesignator = (short) dis.readUnsignedByte();
            systemSpecificData = (short) dis.readUnsignedByte();
            fundamentalOperationalData.unmarshal(dis);
        } // end try 
        catch (Exception e) {
            System.out.println(e);
        }
    } // end of unmarshal method 

    public void marshal(java.nio.ByteBuffer buff) {
        emittingEntityId.marshal(buff);
        eventId.marshal(buff);
        relativeAntennaLocation.marshal(buff);
        systemId.marshal(buff);
        buff.put((byte) systemDesignator);
        buff.put((byte) systemSpecificData);
        fundamentalOperationalData.marshal(buff);
    } // end of marshal method

    public void unmarshal(java.nio.ByteBuffer buff) {
        emittingEntityId.unmarshal(buff);
        eventId.unmarshal(buff);
        relativeAntennaLocation.unmarshal(buff);
        systemId.unmarshal(buff);
        systemDesignator = (short) buff.get();
        systemSpecificData = (short) buff.get();
        fundamentalOperationalData.unmarshal(buff);
    } // end of unmarshal method    

    @Override
    public boolean equals(Object obj) {

        if (this == obj) {
            return true;
        }

        if (obj == null) {
            return false;
        }

        if (getClass() != obj.getClass()) {
            return false;
        }

        return equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;

        if (!(obj instanceof IFFLayer1)) {
            return false;
        }
        final IFFLayer1 rhs = (IFFLayer1) obj;

        if (!(emittingEntityId.equals(rhs.emittingEntityId))) {
            ivarsEqual = false;
        }
        if (!(eventId.equals(rhs.eventId))) {
            ivarsEqual = false;
        }
        if (!(relativeAntennaLocation.equals(rhs.relativeAntennaLocation))) {
            ivarsEqual = false;
        }
        if (!(systemId.equals(rhs.systemId))) {
            ivarsEqual = false;
        }
        if (!(systemDesignator == rhs.systemDesignator)) {
            ivarsEqual = false;
        }
        if (!(systemSpecificData == rhs.systemSpecificData)) {
            ivarsEqual = false;
        }

        if (!(fundamentalOperationalData.equals(rhs.fundamentalOperationalData))) {
            ivarsEqual = false;
        }

        return ivarsEqual;
    }
}
