package edu.nps.moves.dis7;

import java.io.*;

/**
 * Jamming technique. Section 6.2.49
 *
 * Copyright (c) 2008-2016, MOVES Institute, Naval Postgraduate School. All
 * rights reserved. This work is licensed under the BSD open source license,
 * available at https://www.movesinstitute.org/licenses/bsd.html
 *
 * @author DMcG
 */
public class JammingTechnique extends Object implements Serializable {

    protected short kind;

    protected short category;

    protected short subcategory;

    protected short specific;

    /**
     * Constructor
     */
    public JammingTechnique() {
    }

    public int getMarshalledSize() {
        int marshalSize = 0;

        marshalSize = marshalSize + 1;  // kind
        marshalSize = marshalSize + 1;  // category
        marshalSize = marshalSize + 1;  // subcategory
        marshalSize = marshalSize + 1;  // specific

        return marshalSize;
    }

    public void setKind(short pKind) {
        kind = pKind;
    }

    public short getKind() {
        return kind;
    }

    public void setCategory(short pCategory) {
        category = pCategory;
    }

    public short getCategory() {
        return category;
    }

    public void setSubcategory(short pSubcategory) {
        subcategory = pSubcategory;
    }

    public short getSubcategory() {
        return subcategory;
    }

    public void setSpecific(short pSpecific) {
        specific = pSpecific;
    }

    public short getSpecific() {
        return specific;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeByte((byte) kind);
            dos.writeByte((byte) category);
            dos.writeByte((byte) subcategory);
            dos.writeByte((byte) specific);
        } // end try 
        catch (Exception e) {
            System.out.println(e);
        }
    } // end of marshal method

    public void unmarshal(DataInputStream dis) {
        try {
            kind = (short) dis.readUnsignedByte();
            category = (short) dis.readUnsignedByte();
            subcategory = (short) dis.readUnsignedByte();
            specific = (short) dis.readUnsignedByte();
        } // end try 
        catch (Exception e) {
            System.out.println(e);
        }
    } // end of unmarshal method 

    /**
     * Packs a Pdu into the ByteBuffer.
     *
     * @throws java.nio.BufferOverflowException if buff is too small
     * @throws java.nio.ReadOnlyBufferException if buff is read only
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin writing
     * @since ??
     */
    public void marshal(java.nio.ByteBuffer buff) {
        buff.put((byte) kind);
        buff.put((byte) category);
        buff.put((byte) subcategory);
        buff.put((byte) specific);
    } // end of marshal method

    /**
     * Unpacks a Pdu from the underlying data.
     *
     * @throws java.nio.BufferUnderflowException if buff is too small
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin reading
     * @since ??
     */
    public void unmarshal(java.nio.ByteBuffer buff) {
        kind = (short) (buff.get() & 0xFF);
        category = (short) (buff.get() & 0xFF);
        subcategory = (short) (buff.get() & 0xFF);
        specific = (short) (buff.get() & 0xFF);
    } // end of unmarshal method 


    /*
  * The equals method doesn't always work--mostly it works only on classes that consist only of primitives. Be careful.
     */
    @Override
    public boolean equals(Object obj) {

        if (this == obj) {
            return true;
        }

        if (obj == null) {
            return false;
        }

        if (getClass() != obj.getClass()) {
            return false;
        }

        return equalsImpl(obj);
    }

    /**
     * Compare all fields that contribute to the state, ignoring transient and
     * static fields, for <code>this</code> and the supplied object
     *
     * @param obj the object to compare to
     * @return true if the objects are equal, false otherwise.
     */
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;

        if (!(obj instanceof JammingTechnique)) {
            return false;
        }

        final JammingTechnique rhs = (JammingTechnique) obj;

        if (!(kind == rhs.kind)) {
            ivarsEqual = false;
        }
        if (!(category == rhs.category)) {
            ivarsEqual = false;
        }
        if (!(subcategory == rhs.subcategory)) {
            ivarsEqual = false;
        }
        if (!(specific == rhs.specific)) {
            ivarsEqual = false;
        }

        return ivarsEqual;
    }
} // end of class
