package edu.nps.moves.dis7;

import java.io.*;

/**
 * The relationship of the part entity to its host entity. Section 6.2.74.
 *
 * Copyright (c) 2008-2016, MOVES Institute, Naval Postgraduate School. All
 * rights reserved. This work is licensed under the BSD open source license,
 * available at https://www.movesinstitute.org/licenses/bsd.html
 *
 * @author DMcG
 */
public class Relationship extends Object implements Serializable {

    /**
     * the nature or purpose for joining of the part entity to the host entity
     * and shall be represented by a 16-bit enumeration
     */
    protected int nature;

    /**
     * the position of the part entity with respect to the host entity and shall
     * be represented by a 16-bit enumeration
     */
    protected int position;

    /**
     * Constructor
     */
    public Relationship() {
    }

    public int getMarshalledSize() {
        int marshalSize = 0;

        marshalSize = marshalSize + 2;  // nature
        marshalSize = marshalSize + 2;  // position

        return marshalSize;
    }

    public void setNature(int pNature) {
        nature = pNature;
    }

    public int getNature() {
        return nature;
    }

    public void setPosition(int pPosition) {
        position = pPosition;
    }

    public int getPosition() {
        return position;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeShort((short) nature);
            dos.writeShort((short) position);
        } // end try 
        catch (Exception e) {
            System.out.println(e);
        }
    } // end of marshal method

    public void unmarshal(DataInputStream dis) {
        try {
            nature = (int) dis.readUnsignedShort();
            position = (int) dis.readUnsignedShort();
        } // end try 
        catch (Exception e) {
            System.out.println(e);
        }
    } // end of unmarshal method 

    /**
     * Packs a Pdu into the ByteBuffer.
     *
     * @throws java.nio.BufferOverflowException if buff is too small
     * @throws java.nio.ReadOnlyBufferException if buff is read only
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin writing
     * @since ??
     */
    public void marshal(java.nio.ByteBuffer buff) {
        buff.putShort((short) nature);
        buff.putShort((short) position);
    } // end of marshal method

    /**
     * Unpacks a Pdu from the underlying data.
     *
     * @throws java.nio.BufferUnderflowException if buff is too small
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin reading
     * @since ??
     */
    public void unmarshal(java.nio.ByteBuffer buff) {
        nature = (int) (buff.getShort() & 0xFFFF);
        position = (int) (buff.getShort() & 0xFFFF);
    } // end of unmarshal method 


    /*
  * The equals method doesn't always work--mostly it works only on classes that consist only of primitives. Be careful.
     */
    @Override
    public boolean equals(Object obj) {

        if (this == obj) {
            return true;
        }

        if (obj == null) {
            return false;
        }

        if (getClass() != obj.getClass()) {
            return false;
        }

        return equalsImpl(obj);
    }

    /**
     * Compare all fields that contribute to the state, ignoring transient and
     * static fields, for <code>this</code> and the supplied object
     *
     * @param obj the object to compare to
     * @return true if the objects are equal, false otherwise.
     */
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;

        if (!(obj instanceof Relationship)) {
            return false;
        }

        final Relationship rhs = (Relationship) obj;

        if (!(nature == rhs.nature)) {
            ivarsEqual = false;
        }
        if (!(position == rhs.position)) {
            ivarsEqual = false;
        }

        return ivarsEqual;
    }
} // end of class
