package edu.nps.moves.dis7;

import java.io.*;

/**
 * A Simulation Address record shall consist of the Site Identification number
 * and the Application Identification number. Section 6.2.79
 *
 * Copyright (c) 2008-2016, MOVES Institute, Naval Postgraduate School. All
 * rights reserved. This work is licensed under the BSD open source license,
 * available at https://www.movesinstitute.org/licenses/bsd.html
 *
 * @author DMcG
 */
public class SimulationAddress extends Object implements Serializable {

    /**
     * A site is defined as a facility, installation, organizational unit or a
     * geographic location that has one or more simulation applications capable
     * of participating in a distributed event.
     */
    protected int site;

    /**
     * An application is defined as a software program that is used to generate
     * and process distributed simulation data including live, virtual and
     * constructive data.
     */
    protected int application;

    /**
     * Constructor
     */
    public SimulationAddress() {
    }

    public int getMarshalledSize() {
        int marshalSize = 0;

        marshalSize = marshalSize + 2;  // site
        marshalSize = marshalSize + 2;  // application

        return marshalSize;
    }

    public void setSite(int pSite) {
        site = pSite;
    }

    public int getSite() {
        return site;
    }

    public void setApplication(int pApplication) {
        application = pApplication;
    }

    public int getApplication() {
        return application;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeShort((short) site);
            dos.writeShort((short) application);
        } // end try 
        catch (Exception e) {
            System.out.println(e);
        }
    } // end of marshal method

    public void unmarshal(DataInputStream dis) {
        try {
            site = (int) dis.readUnsignedShort();
            application = (int) dis.readUnsignedShort();
        } // end try 
        catch (Exception e) {
            System.out.println(e);
        }
    } // end of unmarshal method 

    /**
     * Packs a Pdu into the ByteBuffer.
     *
     * @throws java.nio.BufferOverflowException if buff is too small
     * @throws java.nio.ReadOnlyBufferException if buff is read only
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin writing
     * @since ??
     */
    public void marshal(java.nio.ByteBuffer buff) {
        buff.putShort((short) site);
        buff.putShort((short) application);
    } // end of marshal method

    /**
     * Unpacks a Pdu from the underlying data.
     *
     * @throws java.nio.BufferUnderflowException if buff is too small
     * @see java.nio.ByteBuffer
     * @param buff The ByteBuffer at the position to begin reading
     * @since ??
     */
    public void unmarshal(java.nio.ByteBuffer buff) {
        site = (int) (buff.getShort() & 0xFFFF);
        application = (int) (buff.getShort() & 0xFFFF);
    } // end of unmarshal method 


    /*
  * The equals method doesn't always work--mostly it works only on classes that consist only of primitives. Be careful.
     */
    @Override
    public boolean equals(Object obj) {

        if (this == obj) {
            return true;
        }

        if (obj == null) {
            return false;
        }

        if (getClass() != obj.getClass()) {
            return false;
        }

        return equalsImpl(obj);
    }

    /**
     * Compare all fields that contribute to the state, ignoring transient and
     * static fields, for <code>this</code> and the supplied object
     *
     * @param obj the object to compare to
     * @return true if the objects are equal, false otherwise.
     */
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;

        if (!(obj instanceof SimulationAddress)) {
            return false;
        }

        final SimulationAddress rhs = (SimulationAddress) obj;

        if (!(site == rhs.site)) {
            ivarsEqual = false;
        }
        if (!(application == rhs.application)) {
            ivarsEqual = false;
        }

        return ivarsEqual;
    }
} // end of class
